/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jar;

import java.io.File;
import java.util.Properties;
import org.apache.maven.plugin.jar.AbstractJarPluginTestCase;

public class JarMojoIntegrationTest
extends AbstractJarPluginTestCase {
    protected String getGoal() {
        return "jar";
    }

    public void testMJar_30_01() throws Exception {
        this.doTestProject("mjar-30-01", null, new String[]{"default-configuration.properties", "foo/project001/App.class", "META-INF/MANIFEST.MF", "META-INF/maven/org.apache.maven.plugins/maven-jar-plugin-test-mjar-30-01/pom.properties", "META-INF/maven/org.apache.maven.plugins/maven-jar-plugin-test-mjar-30-01/pom.xml"});
    }

    public void testMJar_30_02() throws Exception {
        this.doTestProject("mjar-30-02", null, new String[]{"service/TestInterface.class", "META-INF/MANIFEST.MF", "META-INF/maven/org.apache.maven.plugins/maven-jar-plugin-test-mjar-30-02/pom.properties", "META-INF/maven/org.apache.maven.plugins/maven-jar-plugin-test-mjar-30-02/pom.xml"});
    }

    public void testMJar_30_03() throws Exception {
        this.doTestProject("mjar-30-03", null, new String[]{"default-configuration.properties", "META-INF/MANIFEST.MF", "META-INF/maven/org.apache.maven.plugins/maven-jar-plugin-test-mjar-30-03/pom.properties", "META-INF/maven/org.apache.maven.plugins/maven-jar-plugin-test-mjar-30-03/pom.xml"});
    }

    public void testMultipleJars() throws Exception {
        String projectName = "project-004";
        File baseDir = this.executeMojo(projectName, new Properties());
        this.assertJarArchive(baseDir, projectName, null);
        this.assertArchiveContent(baseDir, projectName, null, new String[]{"service/TestInterface.class", "service/impl/TestImplementation.class", "TestCompile1.class", "notIncluded.xml", "META-INF/MANIFEST.MF", "META-INF/maven/org.apache.maven.plugins/maven-jar-plugin-test-project-004/pom.properties", "META-INF/maven/org.apache.maven.plugins/maven-jar-plugin-test-project-004/pom.xml"});
        this.assertJarArchive(baseDir, projectName, "service");
        this.assertArchiveContent(baseDir, projectName, "service", new String[]{"service/TestInterface.class", "META-INF/MANIFEST.MF", "META-INF/maven/org.apache.maven.plugins/maven-jar-plugin-test-project-004/pom.properties", "META-INF/maven/org.apache.maven.plugins/maven-jar-plugin-test-project-004/pom.xml"});
    }
}

