/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.jar.JarSignVerifyMojo;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JarSignVerifyMojoTest
extends TestCase {
    private MockJarSignVerifyMojo mojo;

    public void setUp() throws IOException {
        this.mojo = new MockJarSignVerifyMojo();
        this.mojo.executeResult = 0;
        File basedir = new File(System.getProperty("java.io.tmpdir"));
        this.mojo.setBasedir(basedir);
        this.mojo.setWorkingDir(basedir);
        this.mojo.setJarPath(new File("/tmp/signed/file-version.jar"));
    }

    public void tearDown() {
        this.mojo = null;
    }

    public void testPleaseMaven() {
        JarSignVerifyMojoTest.assertTrue((boolean)true);
    }

    public void testRunOK() throws MojoExecutionException {
        this.mojo.lastOutLine = "jar verified.";
        this.mojo.execute();
        String[] expectedArguments = new String[]{"-verify", "/tmp/signed/file-version.jar"};
        this.checkMojo(expectedArguments);
    }

    public void testRunOKAllArguments() throws MojoExecutionException {
        this.mojo.lastOutLine = "jar verified.";
        this.mojo.setVerbose(true);
        this.mojo.setCheckCerts(true);
        this.mojo.execute();
        String[] expectedArguments = new String[]{"-verify", "-verbose", "-certs", "/tmp/signed/file-version.jar"};
        this.checkMojo(expectedArguments);
    }

    public void testRunFailureNeverHappens() {
        this.mojo.executeResult = 1;
        try {
            this.mojo.execute();
            JarSignVerifyMojoTest.fail((String)"expected failure");
        }
        catch (MojoExecutionException e) {
            JarSignVerifyMojoTest.assertTrue((boolean)e.getMessage().startsWith("Result of "));
        }
        String[] expectedArguments = new String[]{"-verify", "/tmp/signed/file-version.jar"};
        this.checkMojo(expectedArguments);
    }

    public void testRunFailureVerifyFailed() {
        this.mojo.lastOutLine = "jar is unsigned.";
        try {
            this.mojo.execute();
            JarSignVerifyMojoTest.fail((String)"expected failure");
        }
        catch (MojoExecutionException e) {
            JarSignVerifyMojoTest.assertTrue((boolean)e.getMessage().startsWith("Verify failed: jar is unsigned."));
        }
        String[] expectedArguments = new String[]{"-verify", "/tmp/signed/file-version.jar"};
        this.checkMojo(expectedArguments);
    }

    public void testRunError() {
        this.mojo.failureMsg = "simulated failure";
        try {
            this.mojo.execute();
            JarSignVerifyMojoTest.fail((String)"expected failure");
        }
        catch (MojoExecutionException e) {
            JarSignVerifyMojoTest.assertEquals((String)"command execution failed", (String)e.getMessage());
        }
        String[] expectedArguments = new String[]{"-verify", "/tmp/signed/file-version.jar"};
        this.checkMojo(expectedArguments);
    }

    private void checkMojo(String[] expectedCommandLineArguments) {
        JarSignVerifyMojoTest.checkMojo(this.mojo, expectedCommandLineArguments);
    }

    static void checkMojo(MockJarSignVerifyMojo mojo, String[] expectedCommandLineArguments) {
        JarSignVerifyMojoTest.assertEquals((int)1, (int)mojo.commandLines.size());
        Commandline commandline = (Commandline)mojo.commandLines.get(0);
        String[] arguments = commandline.getArguments();
        JarSignVerifyMojoTest.assertEquals((String)"Differing number of arguments", (int)expectedCommandLineArguments.length, (int)arguments.length);
        int i = 0;
        while (i < arguments.length) {
            expectedCommandLineArguments[i] = StringUtils.replace((String)expectedCommandLineArguments[i], (String)"/", (String)File.separator);
            JarSignVerifyMojoTest.assertEquals((String)expectedCommandLineArguments[i], (String)expectedCommandLineArguments[i], (String)arguments[i]);
            ++i;
        }
    }

    static class MockJarSignVerifyMojo
    extends JarSignVerifyMojo {
        public int executeResult;
        public List commandLines = new ArrayList();
        public String failureMsg;
        public Map systemProperties = new HashMap();
        public String lastOutLine;

        MockJarSignVerifyMojo() {
        }

        protected int executeCommandLine(Commandline commandLine, InputStream inputStream, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
            this.commandLines.add(commandLine);
            if (this.failureMsg != null) {
                throw new CommandLineException(this.failureMsg);
            }
            if (this.lastOutLine != null) {
                systemOut.consumeLine(this.lastOutLine);
            }
            return this.executeResult;
        }

        protected String getSystemProperty(String key) {
            return (String)this.systemProperties.get(key);
        }
    }
}

