/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class JavadocJar
extends AbstractMojo {
    private String outputDirectory;
    private String finalName;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private boolean attach = true;

    public void execute() throws MojoExecutionException {
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            this.getLog().info((CharSequence)"Not executing Javadoc as the project is not a Java classpath-capable package");
            return;
        }
        try {
            File outputFile = this.generateArchive(this.outputDirectory + "/javadoc", this.finalName + "-javadoc.jar");
            if (!this.attach) {
                this.getLog().info((CharSequence)"NOT adding javadoc to attached artifacts list.");
            } else {
                this.projectHelper.attachArtifact(this.project, "javadoc", "javadoc", outputFile);
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error while creating archive.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while creating archive.", (Exception)e);
        }
    }

    private File generateArchive(String source, String target) throws MojoExecutionException, ArchiverException, IOException {
        File javadocFiles = new File(source);
        if (!javadocFiles.exists()) {
            throw new MojoExecutionException("javadoc files not found.");
        }
        File javadocJar = new File(this.outputDirectory, target);
        if (javadocJar.exists()) {
            javadocJar.delete();
        }
        JarArchiver archiver = new JarArchiver();
        archiver.addDirectory(javadocFiles);
        archiver.setDestFile(javadocJar);
        archiver.createArchive();
        return javadocJar;
    }
}

