/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.javadoc.OfflineLink;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavadocReport
extends AbstractMavenReport {
    private static final String RESOURCE_DIR = ClassUtils.getPackageName((Class)(class$org$apache$maven$plugin$javadoc$JavadocReport == null ? (class$org$apache$maven$plugin$javadoc$JavadocReport = JavadocReport.class$("org.apache.maven.plugin.javadoc.JavadocReport")) : class$org$apache$maven$plugin$javadoc$JavadocReport)).replace('.', '/');
    private static final String DEFAULT_CSS_NAME = "stylesheet.css";
    private static final String RESOURCE_CSS_DIR = RESOURCE_DIR + "/css";
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private boolean isOffline;
    private File outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    private String additionalparam;
    private boolean breakiterator = false;
    private String doclet;
    private String docletPath;
    private String encoding;
    private String excludePackageNames;
    private String extdirs;
    private String locale;
    private String maxmemory;
    private String minmemory;
    private boolean old = false;
    private String overview;
    private boolean showPackage = true;
    private boolean showProtected = false;
    private boolean showPrivate = false;
    private boolean public_ = false;
    private boolean quiet = false;
    private String source;
    private boolean verbose = false;
    private boolean author = true;
    private String bottom;
    private String charset = "ISO-8859-1";
    private boolean docfilessubdirs = false;
    private String docencoding;
    private String doctitle;
    private String excludedocfilessubdir;
    private String footer;
    private String group;
    private String header;
    private String helpfile;
    private ArrayList links;
    private ArrayList offlineLinks;
    private boolean linksource = false;
    private boolean nocomment = false;
    private boolean nodeprecated = false;
    private boolean nodeprecatedlist = false;
    private boolean nohelp = false;
    private boolean noindex = false;
    private boolean nonavbar = false;
    private String noqualifier;
    private boolean nosince = false;
    private boolean notree = false;
    private boolean serialwarn = false;
    private boolean splitindex = false;
    private String stylesheetfile;
    private ArrayList tags;
    private String tag;
    private String taglet;
    private String tagletpath;
    private boolean use = true;
    private boolean version = true;
    private String windowtitle;
    static /* synthetic */ Class class$org$apache$maven$plugin$javadoc$JavadocReport;

    public String getName(Locale locale) {
        return "JavaDocs";
    }

    public String getDescription(Locale locale) {
        return "JavaDoc API documentation.";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.executeReport(locale);
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            this.getLog().info((CharSequence)"Not executing Javadoc as the project is not a Java classpath-capable package");
            return;
        }
        int actualYear = Calendar.getInstance().get(1);
        String year = String.valueOf(actualYear);
        Model model = this.getProject().getModel();
        if (model.getInceptionYear() != null) {
            if (StringUtils.isNumeric((String)model.getInceptionYear())) {
                if (Integer.valueOf(model.getInceptionYear()) != actualYear) {
                    year = model.getInceptionYear() + "-" + String.valueOf(actualYear);
                }
            } else {
                this.getLog().warn((CharSequence)"The inception year is not a valid year.");
            }
        }
        StringBuffer options = new StringBuffer();
        StringBuffer classpath = new StringBuffer();
        try {
            Iterator i = this.getProject().getCompileClasspathElements().iterator();
            while (i.hasNext()) {
                classpath.append((String)i.next());
                if (!i.hasNext()) continue;
                classpath.append(PATH_SEPARATOR);
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MavenReportException("Error in plugin descriptor - compile dependencies were not resolved", (Exception)((Object)e));
        }
        if (classpath.length() > 0) {
            options.append("-classpath ");
            options.append(this.quotedPathArgument(classpath.toString()));
        }
        StringBuffer sourcePath = new StringBuffer();
        StringBuffer files = new StringBuffer();
        Iterator i = this.getProject().getCompileSourceRoots().iterator();
        while (i.hasNext()) {
            String sourceDirectory = (String)i.next();
            String[] fileList = FileUtils.getFilesFromExtension((String)sourceDirectory, (String[])new String[]{"java"});
            if (fileList != null && fileList.length != 0) {
                for (int j = 0; j < fileList.length; ++j) {
                    files.append(this.quotedPathArgument(fileList[j]));
                    files.append("\n");
                }
            }
            sourcePath.append(sourceDirectory);
            if (!i.hasNext()) continue;
            sourcePath.append(PATH_SEPARATOR);
        }
        if (files.length() == 0) {
            return;
        }
        File javadocDirectory = this.getReportOutputDirectory();
        if (!javadocDirectory.getAbsolutePath().equals(this.getOutputDirectory())) {
            javadocDirectory = new File(javadocDirectory, "apidocs");
        }
        javadocDirectory.mkdirs();
        File file = new File(javadocDirectory, "files");
        file.deleteOnExit();
        try {
            FileUtils.fileWrite((String)file.getAbsolutePath(), (String)files.toString());
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to write temporary file for command execution", (Exception)e);
        }
        try {
            this.copyDefaultStylesheet(javadocDirectory);
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy default stylesheet", (Exception)e);
        }
        Commandline cmd = new Commandline();
        if (!StringUtils.isEmpty((String)this.maxmemory)) {
            if (NumberUtils.isDigits((String)this.maxmemory)) {
                cmd.createArgument().setValue("-J-Xmx" + this.maxmemory + "m");
            } else if (NumberUtils.isDigits((String)this.maxmemory.substring(0, this.maxmemory.length() - 1)) && this.maxmemory.toLowerCase().endsWith("m")) {
                cmd.createArgument().setValue("-J-Xmx" + this.maxmemory);
            } else {
                this.getLog().error((CharSequence)("The maxmemory '" + this.maxmemory + "' is not a valid number. Ignore this option."));
            }
        }
        if (!StringUtils.isEmpty((String)this.minmemory)) {
            if (NumberUtils.isDigits((String)this.minmemory)) {
                cmd.createArgument().setValue("-J-Xms" + this.minmemory + "m");
            } else if (NumberUtils.isDigits((String)this.minmemory.substring(0, this.minmemory.length() - 1)) && this.minmemory.toLowerCase().endsWith("m")) {
                cmd.createArgument().setValue("-J-Xms" + this.minmemory);
            } else {
                this.getLog().error((CharSequence)("The minmemory '" + this.minmemory + "' is not a valid number. Ignore this option."));
            }
        }
        ArrayList arguments = new ArrayList();
        cmd.setWorkingDirectory(javadocDirectory.getAbsolutePath());
        cmd.setExecutable(this.getJavadocPath());
        this.addArgIfNotEmpty(arguments, "-locale", this.quotedArgument(this.locale));
        this.addArgIf(arguments, this.breakiterator, "-breakiterator", 1.4f);
        if (!StringUtils.isEmpty((String)this.doclet)) {
            this.addArgIfNotEmpty(arguments, "-doclet", this.quotedArgument(this.doclet));
            this.addArgIfNotEmpty(arguments, "-docletpath", this.quotedPathArgument(this.docletPath));
        }
        this.addArgIfNotEmpty(arguments, "-encoding", this.quotedArgument(this.encoding));
        this.addArgIfNotEmpty(arguments, "-extdirs", this.quotedPathArgument(this.extdirs));
        this.addArgIfNotEmpty(arguments, "-exclude", this.quotedArgument(this.excludePackageNames), 1.4f);
        if (this.old && SystemUtils.isJavaVersionAtLeast((float)1.4f)) {
            this.getLog().warn((CharSequence)"Javadoc 1.4 doesn't support the -1.1 switch anymore. Ignore this option.");
        } else {
            this.addArgIf(arguments, this.old, "-1.1");
        }
        this.addArgIfNotEmpty(arguments, "-overview", this.quotedArgument(this.overview));
        this.addArgIf(arguments, this.showPackage, "-package");
        this.addArgIf(arguments, this.showPrivate, "-private");
        this.addArgIf(arguments, this.showProtected, "-protected");
        this.addArgIf(arguments, this.public_, "-public");
        this.addArgIf(arguments, this.quiet, "-quiet", 1.4f);
        this.addArgIfNotEmpty(arguments, "-source", this.quotedArgument(this.source), 1.4f);
        this.addArgIf(arguments, this.verbose, "-verbose");
        this.addArgIfNotEmpty(arguments, null, this.quotedArgument(this.additionalparam));
        this.addArgIfNotEmpty(arguments, "-sourcePath", this.quotedPathArgument(sourcePath.toString()));
        if (StringUtils.isEmpty((String)this.doclet)) {
            this.bottom = StringUtils.replace((String)this.bottom, (String)"{currentYear}", (String)year);
            this.bottom = this.project.getInceptionYear() != null ? StringUtils.replace((String)this.bottom, (String)"{inceptionYear}", (String)this.project.getInceptionYear()) : StringUtils.replace((String)this.bottom, (String)"{inceptionYear}-", (String)"");
            if (StringUtils.isEmpty((String)this.stylesheetfile)) {
                this.stylesheetfile = javadocDirectory + File.separator + DEFAULT_CSS_NAME;
            }
            this.addArgIf(arguments, this.author, "-author");
            this.addArgIfNotEmpty(arguments, "-bottom", this.quotedArgument(this.bottom));
            this.addArgIf(arguments, this.breakiterator, "-breakiterator", 1.4f);
            this.addArgIfNotEmpty(arguments, "-charset", this.quotedArgument(this.charset));
            this.addArgIfNotEmpty(arguments, "-d", this.quotedPathArgument(javadocDirectory.toString()));
            this.addArgIf(arguments, this.docfilessubdirs, "-docfilessubdirs", 1.4f);
            this.addArgIfNotEmpty(arguments, "-docencoding", this.quotedArgument(this.docencoding));
            this.addArgIfNotEmpty(arguments, "-doctitle", this.quotedArgument(this.doctitle));
            this.addArgIfNotEmpty(arguments, "-excludedocfilessubdir", this.quotedPathArgument(this.excludedocfilessubdir), 1.4f);
            this.addArgIfNotEmpty(arguments, "-footer", this.quotedArgument(this.footer));
            this.addArgIfNotEmpty(arguments, "-group", this.quotedArgument(this.group), true);
            this.addArgIfNotEmpty(arguments, "-header", this.quotedArgument(this.header));
            this.addArgIfNotEmpty(arguments, "-helpfile", this.quotedPathArgument(this.helpfile));
            if (!this.isOffline) {
                this.addLinkArguments(arguments);
                this.addLinkofflineArguments(arguments);
                this.addArgIf(arguments, this.linksource, "-linksource", 1.4f);
            }
            this.addArgIf(arguments, this.nodeprecated, "-nodeprecated");
            this.addArgIf(arguments, this.nodeprecatedlist, "-nodeprecatedlist");
            this.addArgIf(arguments, this.nocomment, "-nocomment", 1.4f);
            this.addArgIf(arguments, this.nohelp, "-nohelp");
            this.addArgIf(arguments, this.noindex, "-noindex");
            this.addArgIf(arguments, this.nonavbar, "-nonavbar");
            this.addArgIfNotEmpty(arguments, "-noqualifier", this.quotedArgument(this.noqualifier), 1.4f);
            this.addArgIf(arguments, this.nosince, "-nosince");
            this.addArgIf(arguments, this.notree, "-notree");
            this.addArgIf(arguments, this.serialwarn, "-serialwarn");
            this.addArgIf(arguments, this.splitindex, "-splitindex");
            this.addArgIfNotEmpty(arguments, "-stylesheetfile", this.quotedPathArgument(this.stylesheetfile));
            this.addArgIfNotEmpty(arguments, "-tag", this.quotedArgument(this.tag), 1.4f, true);
            if (this.tags != null && !this.tags.isEmpty()) {
                Iterator it = ((AbstractList)this.tags).iterator();
                while (it.hasNext()) {
                    String tag = (String)it.next();
                    this.addArgIfNotEmpty(arguments, "-tag", this.quotedArgument(tag), 1.4f, true);
                }
            }
            this.addArgIfNotEmpty(arguments, "-taglet", this.quotedArgument(this.taglet), 1.4f);
            this.addArgIfNotEmpty(arguments, "-tagletpath", this.quotedPathArgument(this.tagletpath), 1.4f);
            this.addArgIf(arguments, this.use, "-use");
            this.addArgIf(arguments, this.version, "-version");
            this.addArgIfNotEmpty(arguments, "-windowtitle", this.quotedArgument(this.windowtitle));
        }
        if (options.length() > 0) {
            File optionsFile = new File(javadocDirectory, "options");
            Iterator it = arguments.iterator();
            while (it.hasNext()) {
                options.append(" ");
                options.append((String)it.next());
            }
            try {
                FileUtils.fileWrite((String)optionsFile.getAbsolutePath(), (String)options.toString());
            }
            catch (IOException e) {
                throw new MavenReportException("Unable to write temporary file for command execution", (Exception)e);
            }
            cmd.createArgument().setValue("@options");
            optionsFile.deleteOnExit();
        }
        cmd.createArgument().setValue("@files");
        this.getLog().info((CharSequence)Commandline.toString((String[])cmd.getCommandline()));
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)err);
            if (exitCode != 0) {
                throw new MavenReportException("Exit code: " + exitCode + " - " + err.getOutput());
            }
        }
        catch (CommandLineException e) {
            throw new MavenReportException("Unable to execute javadoc command", (Exception)((Object)e));
        }
    }

    public String getOutputName() {
        return "apidocs/index";
    }

    private String getJavadocPath() {
        String javadocCommand = "javadoc" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        File javadocExe = SystemUtils.IS_OS_AIX ? new File(SystemUtils.getJavaHome() + "/../sh", javadocCommand) : (SystemUtils.IS_OS_MAC_OSX ? new File(SystemUtils.getJavaHome() + "/bin", javadocCommand) : new File(SystemUtils.getJavaHome() + "/../bin", javadocCommand));
        this.getLog().debug((CharSequence)("Javadoc executable=[" + javadocExe.getAbsolutePath() + "]"));
        return javadocExe.getAbsolutePath();
    }

    private void addArgIf(List arguments, boolean b, String value) {
        if (b) {
            arguments.add(value);
        }
    }

    private void addArgIf(List arguments, boolean b, String value, float requiredJavaVersion) {
        if (SystemUtils.isJavaVersionAtLeast((float)requiredJavaVersion)) {
            this.addArgIf(arguments, b, value);
        } else {
            this.getLog().warn((CharSequence)(value + " option is not supported on Java version < " + requiredJavaVersion));
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value) {
        this.addArgIfNotEmpty(arguments, key, value, false);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey) {
        if (!StringUtils.isEmpty((String)value)) {
            if (!StringUtils.isEmpty((String)key)) {
                arguments.add(key);
            }
            StringTokenizer token = new StringTokenizer(value, ",");
            while (token.hasMoreTokens()) {
                String current = token.nextToken().trim();
                if (StringUtils.isEmpty((String)current)) continue;
                arguments.add(current);
                if (!token.hasMoreTokens() || !repeatKey) continue;
                arguments.add(key);
            }
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, float requiredJavaVersion) {
        this.addArgIfNotEmpty(arguments, key, value, requiredJavaVersion, false);
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, float requiredJavaVersion, boolean repeatKey) {
        if (SystemUtils.isJavaVersionAtLeast((float)requiredJavaVersion)) {
            this.addArgIfNotEmpty(arguments, key, value, repeatKey);
        } else {
            this.getLog().warn((CharSequence)(key + " option is not supported on Java version < " + requiredJavaVersion));
        }
    }

    private String quotedArgument(String value) {
        if (!StringUtils.isEmpty((String)value)) {
            return "'" + value + "'";
        }
        return value;
    }

    private String quotedPathArgument(String value) {
        if (!StringUtils.isEmpty((String)value)) {
            return "'" + value.replace('\\', '/') + "'";
        }
        return value;
    }

    private void addLinkofflineArguments(List arguments) {
        if (this.offlineLinks != null) {
            for (int i = 0; i < this.offlineLinks.size(); ++i) {
                OfflineLink offlineLink = (OfflineLink)this.offlineLinks.get(i);
                this.addArgIfNotEmpty(arguments, "-linkoffline", this.quotedPathArgument(offlineLink.getUrl()) + " " + this.quotedPathArgument(offlineLink.getLocation().getAbsolutePath()), true);
            }
        }
    }

    private void addLinkArguments(List arguments) {
        if (this.links != null) {
            for (int i = 0; i < this.links.size(); ++i) {
                this.addArgIfNotEmpty(arguments, "-link", this.quotedPathArgument((String)this.links.get(i)), true);
            }
        }
    }

    private static InputStream getStream(String resource) {
        return (class$org$apache$maven$plugin$javadoc$JavadocReport == null ? (class$org$apache$maven$plugin$javadoc$JavadocReport = JavadocReport.class$("org.apache.maven.plugin.javadoc.JavadocReport")) : class$org$apache$maven$plugin$javadoc$JavadocReport).getClassLoader().getResourceAsStream(resource);
    }

    private void copyDefaultStylesheet(File outputDirectory) throws IOException {
        if (outputDirectory == null || !outputDirectory.exists()) {
            throw new IOException("The outputDirectory " + outputDirectory + " doesn't exists.");
        }
        InputStream is = JavadocReport.getStream(RESOURCE_CSS_DIR + "/" + DEFAULT_CSS_NAME);
        if (is == null) {
            throw new IOException("The resource stylesheet.css doesn't exists.");
        }
        File outputFile = new File(outputDirectory, DEFAULT_CSS_NAME);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FileOutputStream w = new FileOutputStream(outputFile);
        IOUtil.copy((InputStream)is, (OutputStream)w);
        IOUtil.close((InputStream)is);
        IOUtil.close((OutputStream)w);
    }

    public boolean isExternalReport() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

