/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.apache.maven.tools.plugin.util.PluginUtils;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MojoScanner mojoScanner;
    protected String goalPrefix;

    protected abstract File getOutputDirectory();

    protected abstract Generator createGenerator();

    public void execute() throws MojoExecutionException {
        if (!this.project.getPackaging().equals("maven-plugin")) {
            return;
        }
        String defaultGoalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        if (this.goalPrefix == null) {
            this.goalPrefix = defaultGoalPrefix;
        } else {
            this.getLog().warn((CharSequence)("Goal prefix is: " + this.goalPrefix + "; Maven currently expects it to be " + defaultGoalPrefix));
        }
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(this.goalPrefix);
        pluginDescriptor.setName(this.project.getName());
        pluginDescriptor.setDescription(this.project.getDescription());
        try {
            pluginDescriptor.setDependencies(PluginUtils.toComponentDependencies((List)this.project.getRuntimeDependencies()));
            this.mojoScanner.populatePluginDescriptor(this.project, pluginDescriptor);
            this.getOutputDirectory().mkdirs();
            this.createGenerator().execute(this.getOutputDirectory(), pluginDescriptor);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing plugin descriptor", (Exception)e);
        }
        catch (InvalidPluginDescriptorException e) {
            throw new MojoExecutionException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
        catch (ExtractionException e) {
            throw new MojoExecutionException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
    }
}

