/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.validator.UrlValidator;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class LicenseReport
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    static /* synthetic */ Class class$org$apache$maven$report$projectinfo$LicenseReport;

    public String getName(Locale locale) {
        return LicenseReport.getBundle(locale).getString("report.license.name");
    }

    public String getCategoryName() {
        return "Project Info";
    }

    public String getDescription(Locale locale) {
        return LicenseReport.getBundle(locale).getString("report.license.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void executeReport(Locale locale) {
        LicenseRenderer r = new LicenseRenderer(this.getSink(), this.getProject(), locale);
        r.render();
    }

    public String getOutputName() {
        return "license";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("project-info-report", locale, (class$org$apache$maven$report$projectinfo$LicenseReport == null ? (class$org$apache$maven$report$projectinfo$LicenseReport = LicenseReport.class$("org.apache.maven.report.projectinfo.LicenseReport")) : class$org$apache$maven$report$projectinfo$LicenseReport).getClassLoader());
    }

    private static URL baseURL(URL aUrl) {
        String urlTxt = aUrl.toExternalForm();
        int lastSlash = urlTxt.lastIndexOf(47);
        if (lastSlash > -1) {
            try {
                return new URL(urlTxt.substring(0, lastSlash + 1));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return aUrl;
    }

    private static String replaceRelativeLinks(String html, String baseURL) {
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        String serverURL = baseURL.substring(0, baseURL.indexOf(47, baseURL.indexOf("//") + 2));
        html = LicenseReport.replaceParts(html, baseURL, serverURL, "[aA]", "[hH][rR][eE][fF]");
        html = LicenseReport.replaceParts(html, baseURL, serverURL, "[iI][mM][gG]", "[sS][rR][cC]");
        return html;
    }

    private static String replaceParts(String html, String baseURL, String serverURL, String tagPattern, String attributePattern) {
        Pattern anchor = Pattern.compile("(<\\s*" + tagPattern + "\\s+[^>]*" + attributePattern + "\\s*=\\s*\")([^\"]*)\"([^>]*>)");
        StringBuffer sb = new StringBuffer(html);
        int indx = 0;
        boolean done = false;
        while (!done) {
            Matcher mAnchor = anchor.matcher(sb);
            if (mAnchor.find(indx)) {
                indx = mAnchor.end(3);
                if (mAnchor.group(2).startsWith("#")) {
                    // empty if block
                }
                if (mAnchor.group(2).startsWith("/")) {
                    sb.insert(mAnchor.start(2), serverURL);
                    indx += serverURL.length();
                    continue;
                }
                if (mAnchor.group(2).indexOf(58) >= 0) continue;
                sb.insert(mAnchor.start(2), baseURL);
                indx += baseURL.length();
                continue;
            }
            done = true;
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class LicenseRenderer
    extends AbstractMavenReportRenderer {
        private MavenProject project;
        private Locale locale;

        public LicenseRenderer(Sink sink, MavenProject project, Locale locale) {
            super(sink);
            this.project = project;
            this.locale = locale;
        }

        public String getTitle() {
            return LicenseReport.getBundle(this.locale).getString("report.license.title");
        }

        public void renderBody() {
            List licenses = this.project.getModel().getLicenses();
            if (licenses.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(LicenseReport.getBundle(this.locale).getString("report.license.nolicense"));
                this.endSection();
                return;
            }
            this.startSection(LicenseReport.getBundle(this.locale).getString("report.license.overview.title"));
            this.paragraph(LicenseReport.getBundle(this.locale).getString("report.license.overview.intro"));
            this.endSection();
            this.startSection(LicenseReport.getBundle(this.locale).getString("report.license.title"));
            Iterator i = licenses.iterator();
            while (i.hasNext()) {
                License license = (License)i.next();
                String name = license.getName();
                String url = license.getUrl();
                String comments = license.getComments();
                String licenseContent = null;
                URL licenseUrl = null;
                UrlValidator urlValidator = new UrlValidator(1);
                if (urlValidator.isValid(url)) {
                    try {
                        licenseUrl = new URL(url);
                    }
                    catch (MalformedURLException e) {
                        throw new MissingResourceException("The license url [" + url + "] seems to be invalid: " + e.getMessage(), null, null);
                    }
                }
                File licenseFile = new File(this.project.getBasedir(), url);
                if (!licenseFile.exists()) {
                    throw new MissingResourceException("Maven can't find the file " + licenseFile + " on the system.", null, null);
                }
                try {
                    licenseUrl = licenseFile.toURL();
                }
                catch (MalformedURLException e) {
                    throw new MissingResourceException("The license url [" + url + "] seems to be invalid: " + e.getMessage(), null, null);
                }
                InputStream in = null;
                try {
                    in = licenseUrl.openStream();
                    licenseContent = IOUtil.toString((InputStream)in, (String)"ISO-8859-1");
                }
                catch (IOException e) {
                    throw new MissingResourceException("Can't read the url [" + url + "] : " + e.getMessage(), null, null);
                }
                finally {
                    IOUtil.close((InputStream)in);
                }
                this.startSection(name);
                if (!StringUtils.isEmpty((String)comments)) {
                    this.paragraph(comments);
                }
                String licenseContentLC = licenseContent.toLowerCase();
                int bodyStart = licenseContentLC.indexOf("<body");
                int bodyEnd = licenseContentLC.indexOf("</body>");
                if ((licenseContentLC.startsWith("<!doctype html") || licenseContentLC.startsWith("<html>")) && bodyStart >= 0 && bodyEnd >= 0) {
                    bodyStart = licenseContentLC.indexOf(">", bodyStart) + 1;
                    String body = licenseContent.substring(bodyStart, bodyEnd);
                    this.link("[Original text]", licenseUrl.toExternalForm());
                    this.paragraph("Copy of the license follows.");
                    body = LicenseReport.replaceRelativeLinks(body, LicenseReport.baseURL(licenseUrl).toExternalForm());
                    this.sink.rawText(body);
                } else {
                    this.verbatimText(licenseContent);
                }
                this.endSection();
            }
            this.endSection();
        }
    }
}

