/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.StringUtils;

public class MailingListsReport
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    static /* synthetic */ Class class$org$apache$maven$report$projectinfo$MailingListsReport;

    public String getName(Locale locale) {
        return MailingListsReport.getBundle(locale).getString("report.mailing-lists.name");
    }

    public String getCategoryName() {
        return "Project Info";
    }

    public String getDescription(Locale locale) {
        return MailingListsReport.getBundle(locale).getString("report.mailing-lists.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void executeReport(Locale locale) {
        MailingListsRenderer r = new MailingListsRenderer(this.getSink(), this.getProject().getModel(), locale);
        r.render();
    }

    public String getOutputName() {
        return "mail-lists";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("project-info-report", locale, (class$org$apache$maven$report$projectinfo$MailingListsReport == null ? (class$org$apache$maven$report$projectinfo$MailingListsReport = MailingListsReport.class$("org.apache.maven.report.projectinfo.MailingListsReport")) : class$org$apache$maven$report$projectinfo$MailingListsReport).getClassLoader());
    }

    private static String getArchiveServer(String uri) {
        if (StringUtils.isEmpty((String)uri)) {
            return "???UNKNOWN???";
        }
        int at = uri.indexOf("//");
        int from = uri.indexOf("/", at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0);
        return uri.substring(at + 2, from);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MailingListsRenderer
    extends AbstractMavenReportRenderer {
        private Model model;
        private Locale locale;

        public MailingListsRenderer(Sink sink, Model model, Locale locale) {
            super(sink);
            this.model = model;
            this.locale = locale;
        }

        public String getTitle() {
            return MailingListsReport.getBundle(this.locale).getString("report.mailing-lists.title");
        }

        public void renderBody() {
            List mailingLists = this.model.getMailingLists();
            if (mailingLists == null || mailingLists.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(MailingListsReport.getBundle(this.locale).getString("report.mailing-lists.nolist"));
                this.endSection();
                return;
            }
            this.startSection(this.getTitle());
            this.paragraph(MailingListsReport.getBundle(this.locale).getString("report.mailing-lists.intro"));
            this.startTable();
            boolean otherArchives = false;
            Iterator i = mailingLists.iterator();
            while (i.hasNext()) {
                MailingList m = (MailingList)i.next();
                if (m.getOtherArchives() == null || m.getOtherArchives().isEmpty()) continue;
                otherArchives = true;
            }
            String name = MailingListsReport.getBundle(this.locale).getString("report.mailing-lists.column.name");
            String subscribe = MailingListsReport.getBundle(this.locale).getString("report.mailing-lists.column.subscribe");
            String unsubscribe = MailingListsReport.getBundle(this.locale).getString("report.mailing-lists.column.unsubscribe");
            String post = MailingListsReport.getBundle(this.locale).getString("report.mailing-lists.column.post");
            String archive = MailingListsReport.getBundle(this.locale).getString("report.mailing-lists.column.archive");
            String archivesOther = MailingListsReport.getBundle(this.locale).getString("report.mailing-lists.column.otherArchives");
            if (otherArchives) {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive, archivesOther});
            } else {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive});
            }
            Iterator i2 = this.model.getMailingLists().iterator();
            while (i2.hasNext()) {
                MailingList mailingList = (MailingList)i2.next();
                ArrayList<String> textRow = new ArrayList<String>();
                textRow.add(mailingList.getName());
                textRow.add(AbstractMavenReportRenderer.createLinkPatternedText((String)subscribe, (String)mailingList.getSubscribe()));
                textRow.add(AbstractMavenReportRenderer.createLinkPatternedText((String)unsubscribe, (String)mailingList.getUnsubscribe()));
                if (mailingList.getPost() != null && mailingList.getPost().length() > 0) {
                    textRow.add(AbstractMavenReportRenderer.createLinkPatternedText((String)post, (String)mailingList.getPost()));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getArchive() != null && mailingList.getArchive().length() > 0) {
                    textRow.add(AbstractMavenReportRenderer.createLinkPatternedText((String)MailingListsReport.getArchiveServer(mailingList.getArchive()), (String)mailingList.getArchive()));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getOtherArchives() != null && !mailingList.getOtherArchives().isEmpty()) {
                    Iterator it = mailingList.getOtherArchives().iterator();
                    String otherArchive = it.next().toString();
                    textRow.add(AbstractMavenReportRenderer.createLinkPatternedText((String)MailingListsReport.getArchiveServer(otherArchive), (String)otherArchive));
                    this.tableRow(textRow.toArray(new String[0]));
                    while (it.hasNext()) {
                        otherArchive = (String)it.next();
                        textRow = new ArrayList();
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(AbstractMavenReportRenderer.createLinkPatternedText((String)MailingListsReport.getArchiveServer(otherArchive), (String)otherArchive));
                        this.tableRow(textRow.toArray(new String[0]));
                    }
                    continue;
                }
                if (otherArchives) {
                    textRow.add(null);
                }
                this.tableRow(textRow.toArray(new String[0]));
            }
            this.endTable();
            this.endSection();
        }
    }
}

