/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.clearcase.repository.ClearCaseScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.StringUtils;

public class ScmReport
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    protected ScmManager scmManager;
    static /* synthetic */ Class class$org$apache$maven$report$projectinfo$ScmReport;

    public String getName(Locale locale) {
        return ScmReport.getBundle(locale).getString("report.scm.name");
    }

    public String getCategoryName() {
        return "Project Info";
    }

    public String getDescription(Locale locale) {
        return ScmReport.getBundle(locale).getString("report.scm.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void executeReport(Locale locale) {
        ScmRenderer r = new ScmRenderer(this.scmManager, this.getSink(), this.getProject().getModel(), locale);
        r.render();
    }

    public String getOutputName() {
        return "source-repository";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("project-info-report", locale, (class$org$apache$maven$report$projectinfo$ScmReport == null ? (class$org$apache$maven$report$projectinfo$ScmReport = ScmReport.class$("org.apache.maven.report.projectinfo.ScmReport")) : class$org$apache$maven$report$projectinfo$ScmReport).getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ScmRenderer
    extends AbstractMavenReportRenderer {
        private Model model;
        private Locale locale;
        private ScmManager scmManager;
        private String anonymousConnection;
        private String devConnection;

        public ScmRenderer(ScmManager scmManager, Sink sink, Model model, Locale locale) {
            super(sink);
            this.scmManager = scmManager;
            this.model = model;
            this.locale = locale;
        }

        public String getTitle() {
            return ScmReport.getBundle(this.locale).getString("report.scm.title");
        }

        public void renderBody() {
            Scm scm = this.model.getScm();
            if (scm == null) {
                this.startSection(this.getTitle());
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.noscm"));
                this.endSection();
                return;
            }
            this.anonymousConnection = scm.getConnection();
            this.devConnection = scm.getDeveloperConnection();
            if (StringUtils.isEmpty((String)this.anonymousConnection) && StringUtils.isEmpty((String)this.devConnection) && StringUtils.isEmpty((String)scm.getUrl())) {
                this.startSection(this.getTitle());
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.noscm"));
                this.endSection();
                return;
            }
            ScmRepository anonymousRepository = this.getScmRepository(this.anonymousConnection);
            ScmRepository devRepository = this.getScmRepository(this.devConnection);
            this.renderOverViewSection(anonymousRepository);
            this.renderWebAccesSection(scm.getUrl());
            this.renderAnonymousAccessSection(anonymousRepository);
            this.renderDeveloperAccessSection(devRepository);
            this.renderAccessBehindFirewallSection(devRepository);
            this.renderAccessThroughProxySection(anonymousRepository, devRepository);
        }

        private void renderOverViewSection(ScmRepository anonymousRepository) {
            this.startSection(ScmReport.getBundle(this.locale).getString("report.scm.overview.title"));
            if (ScmRenderer.isScmSystem(anonymousRepository, "clearcase")) {
                this.linkPatternedText(ScmReport.getBundle(this.locale).getString("report.scm.clearcase.intro"));
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "cvs")) {
                this.linkPatternedText(ScmReport.getBundle(this.locale).getString("report.scm.cvs.intro"));
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "perforce")) {
                this.linkPatternedText(ScmReport.getBundle(this.locale).getString("report.scm.perforce.intro"));
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "starteam")) {
                this.linkPatternedText(ScmReport.getBundle(this.locale).getString("report.scm.starteam.intro"));
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "svn")) {
                this.linkPatternedText(ScmReport.getBundle(this.locale).getString("report.scm.svn.intro"));
            } else {
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.general.intro"));
            }
            this.endSection();
        }

        private void renderWebAccesSection(String scmUrl) {
            this.startSection(ScmReport.getBundle(this.locale).getString("report.scm.webaccess.title"));
            if (StringUtils.isEmpty((String)scmUrl)) {
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.webaccess.nourl"));
            } else {
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.webaccess.url"));
                this.verbatimLink(scmUrl, scmUrl);
            }
            this.endSection();
        }

        private void renderAnonymousAccessSection(ScmRepository anonymousRepository) {
            if (ScmRenderer.isScmSystem(anonymousRepository, "clearcase") || ScmRenderer.isScmSystem(anonymousRepository, "perforce") || ScmRenderer.isScmSystem(anonymousRepository, "starteam") || StringUtils.isEmpty((String)this.anonymousConnection)) {
                return;
            }
            this.startSection(ScmReport.getBundle(this.locale).getString("report.scm.anonymousaccess.title"));
            if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "cvs")) {
                CvsScmProviderRepository cvsRepo = (CvsScmProviderRepository)anonymousRepository.getProviderRepository();
                this.anonymousAccessCVS(cvsRepo);
            } else if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)anonymousRepository.getProviderRepository();
                this.anonymousAccessSVN(svnRepo);
            } else {
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.anonymousaccess.general.intro"));
                if (this.anonymousConnection.length() < 4) {
                    throw new IllegalArgumentException("The source repository connection is too short.");
                }
                this.verbatimText(this.anonymousConnection.substring(4));
            }
            this.endSection();
        }

        private void renderDeveloperAccessSection(ScmRepository devRepository) {
            if (StringUtils.isEmpty((String)this.devConnection)) {
                return;
            }
            this.startSection(ScmReport.getBundle(this.locale).getString("report.scm.devaccess.title"));
            if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "clearcase")) {
                ClearCaseScmProviderRepository clearCaseRepo = (ClearCaseScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessClearCase(clearCaseRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "cvs")) {
                CvsScmProviderRepository cvsRepo = (CvsScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessCVS(cvsRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "perforce")) {
                PerforceScmProviderRepository perforceRepo = (PerforceScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessPerforce(perforceRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "starteam")) {
                StarteamScmProviderRepository starteamRepo = (StarteamScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessStarteam(starteamRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessSVN(svnRepo);
            } else {
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.devaccess.general.intro"));
                if (this.devConnection.length() < 4) {
                    throw new IllegalArgumentException("The source repository connection is too short.");
                }
                this.verbatimText(this.devConnection.substring(4));
            }
            this.endSection();
        }

        private void renderAccessBehindFirewallSection(ScmRepository devRepository) {
            this.startSection(ScmReport.getBundle(this.locale).getString("report.scm.accessbehindfirewall.title"));
            if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)devRepository.getProviderRepository();
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.accessbehindfirewall.svn.intro"));
                StringBuffer sb = new StringBuffer();
                sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.model.getArtifactId());
                this.verbatimText(sb.toString());
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "cvs")) {
                this.linkPatternedText(ScmReport.getBundle(this.locale).getString("report.scm.accessbehindfirewall.cvs.intro"));
            } else {
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.accessbehindfirewall.general.intro"));
            }
            this.endSection();
        }

        private void renderAccessThroughProxySection(ScmRepository anonymousRepository, ScmRepository devRepository) {
            if (ScmRenderer.isScmSystem(anonymousRepository, "svn") || ScmRenderer.isScmSystem(devRepository, "svn")) {
                this.startSection(ScmReport.getBundle(this.locale).getString("report.scm.accessthroughtproxy.title"));
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.accessthroughtproxy.svn.intro1"));
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.accessthroughtproxy.svn.intro2"));
                this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.accessthroughtproxy.svn.intro3"));
                StringBuffer sb = new StringBuffer();
                sb.append("[global]");
                sb.append("\n");
                sb.append("http-proxy-host = your.proxy.name").append("\n");
                sb.append("http-proxy-port = 3128").append("\n");
                this.verbatimText(sb.toString());
                this.endSection();
            }
        }

        private void developerAccessClearCase(ClearCaseScmProviderRepository clearCaseRepo) {
            this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.devaccess.clearcase.intro"));
            StringBuffer command = new StringBuffer();
            command.append("$ cleartool checkout ").append(clearCaseRepo.getModule());
            this.verbatimText(command.toString());
        }

        private void anonymousAccessCVS(CvsScmProviderRepository cvsRepo) {
            this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.anonymousaccess.cvs.intro"));
            StringBuffer command = new StringBuffer();
            command.append("$ cvs -d ").append(cvsRepo.getCvsRoot()).append(" login");
            command.append("\n");
            command.append("$ cvs -z3 -d ").append(cvsRepo.getCvsRoot());
            command.append(" co ").append(cvsRepo.getModule());
            this.verbatimText(command.toString());
        }

        private void developerAccessCVS(CvsScmProviderRepository cvsRepo) {
            this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.devaccess.cvs.intro"));
            String cvsRoot = StringUtils.replace((String)cvsRepo.getCvsRoot(), (String)cvsRepo.getUser(), (String)"username");
            StringBuffer command = new StringBuffer();
            command.append("$ cvs -d ").append(cvsRoot).append(" login");
            command.append("\n");
            command.append("$ cvs -z3 -d ").append(cvsRoot).append(" co ").append(cvsRepo.getModule());
            this.verbatimText(command.toString());
        }

        private void developerAccessPerforce(PerforceScmProviderRepository perforceRepo) {
            this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.devaccess.perforce.intro"));
            StringBuffer command = new StringBuffer();
            command.append("$ p4");
            if (!StringUtils.isEmpty((String)perforceRepo.getHost())) {
                command.append(" -H ").append(perforceRepo.getHost());
            }
            if (perforceRepo.getPort() > 0) {
                command.append(" -p " + perforceRepo.getPort());
            }
            command.append(" -u username");
            command.append(" -P password");
            command.append(" ");
            command.append(perforceRepo.getPath());
            command.append("\n");
            command.append("$ p4 submit -c \"A comment\"");
            this.verbatimText(command.toString());
        }

        private void developerAccessStarteam(StarteamScmProviderRepository starteamRepo) {
            this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.devaccess.starteam.intro"));
            StringBuffer command = new StringBuffer();
            String fullUrl = StringUtils.replace((String)starteamRepo.getFullUrl(), (String)starteamRepo.getUser(), (String)"username");
            fullUrl = StringUtils.replace((String)fullUrl, (String)starteamRepo.getPassword(), (String)"password");
            command.append("$ stcmd co -x -nologo -stop -p ");
            command.append(fullUrl);
            command.append(" -is");
            command.append("\n");
            command.append("$ stcmd ci -x -nologo -stop -p ");
            command.append(fullUrl);
            command.append(" -f NCI -is");
            this.verbatimText(command.toString());
        }

        private void anonymousAccessSVN(SvnScmProviderRepository svnRepo) {
            this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.anonymousaccess.svn.intro"));
            StringBuffer sb = new StringBuffer();
            sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.model.getArtifactId());
            this.verbatimText(sb.toString());
        }

        private void developerAccessSVN(SvnScmProviderRepository svnRepo) {
            this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.devaccess.svn.intro1"));
            StringBuffer sb = new StringBuffer();
            sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.model.getArtifactId());
            this.verbatimText(sb.toString());
            this.paragraph(ScmReport.getBundle(this.locale).getString("report.scm.devaccess.svn.intro2"));
            sb = new StringBuffer();
            sb.append("$ svn commit --username your-username -m \"A message\"");
            this.verbatimText(sb.toString());
        }

        public ScmRepository getScmRepository(String scmUrl) {
            if (StringUtils.isEmpty((String)scmUrl)) {
                return null;
            }
            try {
                return this.scmManager.makeScmRepository(scmUrl);
            }
            catch (NoSuchScmProviderException e) {
                return null;
            }
            catch (ScmRepositoryException e) {
                return null;
            }
        }

        private static boolean isScmSystem(ScmRepository scmRepository, String scmProvider) {
            if (StringUtils.isEmpty((String)scmProvider)) {
                return false;
            }
            return scmRepository != null && scmProvider.equalsIgnoreCase(scmRepository.getProvider());
        }
    }
}

