/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.StringUtils;

public class TeamListReport
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    static /* synthetic */ Class class$org$apache$maven$report$projectinfo$TeamListReport;

    public String getName(Locale locale) {
        return TeamListReport.getBundle(locale).getString("report.team-list.name");
    }

    public String getCategoryName() {
        return "Project Info";
    }

    public String getDescription(Locale locale) {
        return TeamListReport.getBundle(locale).getString("report.team-list.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void executeReport(Locale locale) {
        TeamListRenderer r = new TeamListRenderer(this.getSink(), this.getProject().getModel(), locale);
        r.render();
    }

    public String getOutputName() {
        return "team-list";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("project-info-report", locale, (class$org$apache$maven$report$projectinfo$TeamListReport == null ? (class$org$apache$maven$report$projectinfo$TeamListReport = TeamListReport.class$("org.apache.maven.report.projectinfo.TeamListReport")) : class$org$apache$maven$report$projectinfo$TeamListReport).getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TeamListRenderer
    extends AbstractMavenReportRenderer {
        private Model model;
        private Locale locale;

        public TeamListRenderer(Sink sink, Model model, Locale locale) {
            super(sink);
            this.model = model;
            this.locale = locale;
        }

        public String getTitle() {
            return TeamListReport.getBundle(this.locale).getString("report.team-list.title");
        }

        public void renderBody() {
            Properties props;
            Iterator i;
            String properties;
            String actualTime;
            String timeZone;
            String roles;
            String organizationUrl;
            String organization;
            String url;
            String email;
            String name;
            this.startSection(TeamListReport.getBundle(this.locale).getString("report.team-list.intro.title"));
            StringBuffer javascript = new StringBuffer("function offsetDate(id, offset) {\n").append("    var now = new Date();\n").append("    var nowTime = now.getTime();\n").append("    var localOffset = now.getTimezoneOffset();\n").append("    var developerTime = nowTime + ( offset * 60 * 60 * 1000 ) + ( localOffset * 60 * 1000 );\n").append("    var developerDate = new Date(developerTime);\n").append("\n").append("    document.getElementById(id).innerHTML = developerDate;\n").append("}\n").append("\n").append("function init(){\n");
            this.paragraph(TeamListReport.getBundle(this.locale).getString("report.team-list.intro.description1"));
            this.paragraph(TeamListReport.getBundle(this.locale).getString("report.team-list.intro.description2"));
            List developers = this.model.getDevelopers();
            this.startSection(TeamListReport.getBundle(this.locale).getString("report.team-list.developers.title"));
            if (developers == null || developers.isEmpty()) {
                this.paragraph(TeamListReport.getBundle(this.locale).getString("report.team-list.nodeveloper"));
            } else {
                this.paragraph(TeamListReport.getBundle(this.locale).getString("report.team-list.developers.intro"));
                this.startTable();
                String id = TeamListReport.getBundle(this.locale).getString("report.team-list.developers.id");
                name = TeamListReport.getBundle(this.locale).getString("report.team-list.developers.name");
                email = TeamListReport.getBundle(this.locale).getString("report.team-list.developers.email");
                url = TeamListReport.getBundle(this.locale).getString("report.team-list.developers.url");
                organization = TeamListReport.getBundle(this.locale).getString("report.team-list.developers.organization");
                organizationUrl = TeamListReport.getBundle(this.locale).getString("report.team-list.developers.organizationurl");
                roles = TeamListReport.getBundle(this.locale).getString("report.team-list.developers.roles");
                timeZone = TeamListReport.getBundle(this.locale).getString("report.team-list.developers.timezone");
                actualTime = TeamListReport.getBundle(this.locale).getString("report.team-list.developers.actualtime");
                properties = TeamListReport.getBundle(this.locale).getString("report.team-list.developers.properties");
                this.tableHeader(new String[]{id, name, email, url, organization, organizationUrl, roles, timeZone, actualTime, properties});
                int developersRows = 0;
                i = developers.iterator();
                while (i.hasNext()) {
                    Developer developer = (Developer)i.next();
                    this.sink.tableRow();
                    this.tableCell(developer.getId());
                    this.tableCell(developer.getName());
                    this.tableCell(AbstractMavenReportRenderer.createLinkPatternedText((String)developer.getEmail(), (String)developer.getEmail()));
                    this.tableCell(AbstractMavenReportRenderer.createLinkPatternedText((String)developer.getUrl(), (String)developer.getUrl()));
                    this.tableCell(developer.getOrganization());
                    this.tableCell(AbstractMavenReportRenderer.createLinkPatternedText((String)developer.getOrganizationUrl(), (String)developer.getOrganizationUrl()));
                    if (developer.getRoles() != null) {
                        this.tableCell(StringUtils.join((Object[])developer.getRoles().toArray(new String[0]), (String)", "));
                    } else {
                        this.tableCell(null);
                    }
                    this.tableCell(developer.getTimezone());
                    this.sink.tableCell();
                    this.sink.rawText("<span id=\"developer-" + developersRows + "\">");
                    this.text(developer.getTimezone());
                    if (!StringUtils.isEmpty((String)developer.getTimezone())) {
                        javascript.append("    offsetDate('developer-" + developersRows + "', '");
                        javascript.append(developer.getTimezone());
                        javascript.append("');\n");
                    }
                    this.sink.rawText("</span>");
                    this.sink.tableCell_();
                    props = developer.getProperties();
                    if (props != null) {
                        this.tableCell(AbstractMavenReportRenderer.propertiesToString((Properties)props));
                    } else {
                        this.tableCell(null);
                    }
                    this.sink.tableRow_();
                    ++developersRows;
                }
                this.endTable();
            }
            this.endSection();
            List contributors = this.model.getContributors();
            this.startSection(TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.title"));
            if (contributors == null || contributors.isEmpty()) {
                this.paragraph(TeamListReport.getBundle(this.locale).getString("report.team-list.nocontributor"));
            } else {
                this.paragraph(TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.intro"));
                this.startTable();
                name = TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.name");
                email = TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.email");
                url = TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.url");
                organization = TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.organization");
                organizationUrl = TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.organizationurl");
                roles = TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.roles");
                timeZone = TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.timezone");
                actualTime = TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.actualtime");
                properties = TeamListReport.getBundle(this.locale).getString("report.team-list.contributors.properties");
                this.tableHeader(new String[]{name, email, url, organization, organizationUrl, roles, timeZone, actualTime, properties});
                int contributorsRows = 0;
                i = contributors.iterator();
                while (i.hasNext()) {
                    Contributor contributor = (Contributor)i.next();
                    this.sink.tableRow();
                    this.tableCell(contributor.getName());
                    this.tableCell(AbstractMavenReportRenderer.createLinkPatternedText((String)contributor.getEmail(), (String)contributor.getEmail()));
                    this.tableCell(AbstractMavenReportRenderer.createLinkPatternedText((String)contributor.getUrl(), (String)contributor.getUrl()));
                    this.tableCell(contributor.getOrganization());
                    this.tableCell(AbstractMavenReportRenderer.createLinkPatternedText((String)contributor.getOrganizationUrl(), (String)contributor.getOrganizationUrl()));
                    if (contributor.getRoles() != null) {
                        this.tableCell(StringUtils.join((Object[])contributor.getRoles().toArray(new String[0]), (String)", "));
                    } else {
                        this.tableCell(null);
                    }
                    this.tableCell(contributor.getTimezone());
                    this.sink.tableCell();
                    this.sink.rawText("<span id=\"contributor-" + contributorsRows + "\">");
                    this.text(contributor.getTimezone());
                    if (!StringUtils.isEmpty((String)contributor.getTimezone())) {
                        javascript.append("    offsetDate('contributor-" + contributorsRows + "', '");
                        javascript.append(contributor.getTimezone());
                        javascript.append("');\n");
                    }
                    this.sink.rawText("</span>");
                    this.sink.tableCell_();
                    props = contributor.getProperties();
                    if (props != null) {
                        this.tableCell(AbstractMavenReportRenderer.propertiesToString((Properties)props));
                    } else {
                        this.tableCell(null);
                    }
                    this.sink.tableRow_();
                    ++contributorsRows;
                }
                this.endTable();
            }
            this.endSection();
            this.endSection();
            javascript.append("}\n").append("\n").append("window.onLoad = init();\n");
            this.javaScript(javascript.toString());
        }
    }
}

