/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Formatter;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="dependency-info")
public final class DependencyInformationReport
extends AbstractProjectInfoReport {
    private static final String JAR_PACKAGING = "jar";
    @Parameter(defaultValue="${project.groupId}", required=true)
    protected String groupId;
    @Parameter(defaultValue="${project.artifactId}", required=true)
    protected String artifactId;
    @Parameter(defaultValue="${project.version}", required=true)
    protected String version;
    @Parameter(defaultValue="${project.packaging}", required=true)
    protected String packaging;

    public String getOutputName() {
        return "dependency-info";
    }

    @Override
    protected String getI18Nsection() {
        return "dependency-info";
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        new DependencyInformationRenderer(this.getSink(), this.getI18N(locale), locale, this.groupId, this.artifactId, this.version, this.packaging).render();
    }

    private static final class DependencyInformationRenderer
    extends AbstractProjectInfoRenderer {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String packaging;

        public DependencyInformationRenderer(Sink sink, I18N i18n, Locale locale, String groupId, String artifactId, String version, String packaging) {
            super(sink, i18n, locale);
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.packaging = packaging;
        }

        @Override
        protected String getI18Nsection() {
            return "dependency-info";
        }

        protected void renderBody() {
            this.startSection(this.getTitle());
            Formatter mavenDependency = new Formatter().format("<dependency>%n", new Object[0]).format("  <groupId>%s</groupId>%n", this.groupId).format("  <artifactId>%s</artifactId>%n", this.artifactId).format("  <version>%s</version>%n", this.version);
            if (!DependencyInformationReport.JAR_PACKAGING.equals(this.packaging)) {
                mavenDependency = mavenDependency.format("  <type>%s</type>%n", this.packaging);
            }
            this.renderDependencyInfo("Apache Maven", mavenDependency.format("</dependency>", new Object[0]));
            this.renderDependencyInfo("Apache Buildr", new Formatter().format("'%s:%s:%s:%s'", this.groupId, this.artifactId, this.packaging, this.version));
            this.renderDependencyInfo("Apache Ivy", new Formatter().format("<dependency org=\"%s\" name=\"%s\" rev=\"%s\">%n", this.groupId, this.artifactId, this.version).format("  <artifact name=\"%s\" type=\"%s\" />%n", this.artifactId, this.packaging).format("</dependency>", new Object[0]));
            this.renderDependencyInfo("Groovy Grape", new Formatter().format("@Grapes(%n", new Object[0]).format("@Grab(group='%s', module='%s', version='%s')%n", this.groupId, this.artifactId, this.version).format(")", new Object[0]));
            this.renderDependencyInfo("Gradle/Grails", new Formatter().format("compile '%s:%s:%s'", this.groupId, this.artifactId, this.version));
            this.renderDependencyInfo("Scala SBT", new Formatter().format("libraryDependencies += \"%s\" %% \"%s\" %% \"%s\"", this.groupId, this.artifactId, this.version));
            Formatter leiningenDependency = new Formatter().format("[%s", this.groupId);
            if (!this.groupId.equals(this.artifactId)) {
                leiningenDependency.format("/%s", this.artifactId);
            }
            leiningenDependency.format(" \"%s\"]", this.version);
            this.renderDependencyInfo("Leiningen", leiningenDependency);
            this.endSection();
        }

        private void renderDependencyInfo(String name, Formatter formatter) {
            this.startSection(name);
            this.verbatimText(formatter.toString());
            this.endSection();
        }
    }
}

