/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementDependencies {
    private final List<Dependency> managementDependencies;

    public ManagementDependencies(List<Dependency> projectDependencies) {
        this.managementDependencies = projectDependencies;
    }

    public boolean hasDependencies() {
        return this.managementDependencies != null && !this.managementDependencies.isEmpty();
    }

    public List<Dependency> getManagementDependencies() {
        return new ArrayList<Dependency>(this.managementDependencies);
    }

    public Map<String, List<Dependency>> getManagementDependenciesByScope() {
        HashMap<String, List<Dependency>> dependenciesByScope = new HashMap<String, List<Dependency>>();
        for (Dependency dependency : this.managementDependencies) {
            String scope = dependency.getScope() != null ? dependency.getScope() : "compile";
            ArrayList<Dependency> multiValue = (ArrayList<Dependency>)dependenciesByScope.get(scope);
            if (multiValue == null) {
                multiValue = new ArrayList<Dependency>();
            }
            multiValue.add(dependency);
            dependenciesByScope.put(scope, multiValue);
        }
        return dependenciesByScope;
    }
}

