/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.plugins.release.helpers.ReleaseProgressTracker;
import org.apache.maven.plugins.release.helpers.ScmHelper;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerformReleaseMojo
extends AbstractReleaseMojo {
    private File basedir;
    private String goals = "deploy";
    protected String workingDirectory;
    protected MavenProject project;
    private boolean interactive;
    private ReleaseProgressTracker releaseProgress;

    public void execute() throws MojoExecutionException {
        this.checkout();
        this.runGoals();
    }

    private void checkout() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Checking out the project to perform the release ...");
        try {
            ScmHelper scm = this.getScm(this.workingDirectory);
            scm.checkout();
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error is occurred in the checkout process.", e);
        }
    }

    private void runGoals() throws MojoExecutionException {
        List profiles;
        Commandline cl = new Commandline();
        cl.setExecutable("m2");
        cl.setWorkingDirectory(this.workingDirectory);
        cl.createArgument().setLine(this.goals);
        cl.createArgument().setLine("-DperformRelease=true");
        cl.createArgument().setLine("--no-plugin-updates");
        if (!this.interactive) {
            cl.createArgument().setLine("--batch-mode");
        }
        if ((profiles = this.project.getActiveProfiles()) != null && !profiles.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("-P ");
            Iterator it = profiles.iterator();
            while (it.hasNext()) {
                Profile profile = (Profile)it.next();
                buffer.append(profile.getId()).append(",");
            }
            buffer.setLength(buffer.length() - 1);
            cl.createArgument().setLine(buffer.toString());
        }
        DefaultConsumer consumer = new DefaultConsumer();
        try {
            int result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)consumer);
            if (result != 0) {
                throw new MojoExecutionException("Result of m2 execution is: '" + result + "'. Release failed.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Can't run goal " + this.goals, (Exception)((Object)e));
        }
    }

    protected ReleaseProgressTracker getReleaseProgress() throws MojoExecutionException {
        if (this.releaseProgress == null) {
            try {
                this.releaseProgress = ReleaseProgressTracker.load(this.basedir.getAbsolutePath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load release information from file: " + ReleaseProgressTracker.getReleaseProgressFilename(), (Exception)e);
            }
        }
        return this.releaseProgress;
    }
}

