package org.apache.maven.plugins.shade.mojo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-shade-plugin.<br/> Call <pre>  mvn shade:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Oct 28 19:49:42 EDT 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.8)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
@SuppressWarnings( "all" )
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-shade-plugin:1.5", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Shade Plugin", 0 );
        append( sb, "Repackages the project classes together with their dependencies into a single uber-jar, optionally renaming classes or removing unused classes.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 2 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "shade:help", 0 );
            append( sb, "Display help information on maven-shade-plugin.\nCall\n\u00a0\u00a0mvn\u00a0shade:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "shade".equals( goal ) )
        {
            append( sb, "shade:shade", 0 );
            append( sb, "Mojo that performs shading delegating to the Shader component.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactSet", 2 );
                append( sb, "Artifacts to include/exclude from the final artifact. Artifacts are denoted by composite identifiers of the general form groupId:artifactId:type:classifier. Since version 1.3, the wildcard characters \'*\' and \'?\' can be used within the sub parts of those composite identifiers to do pattern matching. For convenience, the syntax groupId is equivalent to groupId:*:*:*, groupId:artifactId is equivalent to groupId:artifactId:*:* and groupId:artifactId:classifier is equivalent to groupId:artifactId:*:classifier. For example:\n<artifactSet>\n\u00a0\u00a0<includes>\n\u00a0\u00a0\u00a0\u00a0<include>org.apache.maven:*</include>\n\u00a0\u00a0</includes>\n\u00a0\u00a0<excludes>\n\u00a0\u00a0\u00a0\u00a0<exclude>*:maven-core</exclude>\n\u00a0\u00a0</excludes>\n</artifactSet>\n", 3 );
                append( sb, "", 0 );

                append( sb, "createDependencyReducedPom (Default: true)", 2 );
                append( sb, "Flag whether to generate a simplified POM for the shaded artifact. If set to true, dependencies that have been included into the uber JAR will be removed from the <dependencies> section of the generated POM. The reduced POM will be named dependency-reduced-pom.xml and is stored into the same directory as the shaded artifact.", 3 );
                append( sb, "Expression: ${createDependencyReducedPom}", 3 );
                append( sb, "", 0 );

                append( sb, "createSourcesJar (Default: false)", 2 );
                append( sb, "When true, it will attempt to create a sources jar as well", 3 );
                append( sb, "Expression: ${createSourcesJar}", 3 );
                append( sb, "", 0 );

                append( sb, "filters", 2 );
                append( sb, "Archive Filters to be used. Allows you to specify an artifact in the form of a composite identifier as used by artifactSet and a set of include/exclude file patterns for filtering which contents of the archive are added to the shaded jar. From a logical perspective, includes are processed before excludes, thus it\'s possible to use an include to collect a set of files from the archive then use excludes to further reduce the set. By default, all files are included and no files are excluded. If multiple filters apply to an artifact, the intersection of the matched files will be included in the final JAR. For example:\n<filters>\n\u00a0\u00a0<filter>\n\u00a0\u00a0\u00a0\u00a0<artifact>junit:junit</artifact>\n\u00a0\u00a0\u00a0\u00a0<includes>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<include>org/junit/**</include>\n\u00a0\u00a0\u00a0\u00a0</includes>\n\u00a0\u00a0\u00a0\u00a0<excludes>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<exclude>org/junit/experimental/**</exclude>\n\u00a0\u00a0\u00a0\u00a0</excludes>\n\u00a0\u00a0</filter>\n</filters>\n", 3 );
                append( sb, "", 0 );

                append( sb, "finalName", 2 );
                append( sb, "The name of the shaded artifactId. If you like to change the name of the native artifact, you may use the <build><finalName> setting. If this is set to something different than <build><finalName>, no file replacement will be performed, even if shadedArtifactAttached is being used.", 3 );
                append( sb, "Expression: ${finalName}", 3 );
                append( sb, "", 0 );

                append( sb, "keepDependenciesWithProvidedScope (Default: false)", 2 );
                append( sb, "When true, dependencies are kept in the pom but with scope \'provided\'; when false, the dependency is removed.", 3 );
                append( sb, "Expression: ${keepDependenciesWithProvidedScope}", 3 );
                append( sb, "", 0 );

                append( sb, "minimizeJar (Default: false)", 2 );
                append( sb, "When true, dependencies will be stripped down on the class level to only the transitive hull required for the artifact. Note: Usage of this feature requires Java 1.5 or higher.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The destination directory for the shaded artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "The path to the output file for the shaded artifact. When this parameter is set, the created archive will neither replace the project\'s main artifact nor will it be attached. Hence, this parameter causes the parameters finalName, shadedArtifactAttached, shadedClassifierName and createDependencyReducedPom to be ignored when used.", 3 );
                append( sb, "", 0 );

                append( sb, "promoteTransitiveDependencies (Default: false)", 2 );
                append( sb, "When true, transitive deps of removed dependencies are promoted to direct dependencies. This should allow the drop in replacement of the removed deps with the new shaded jar and everything should still work.", 3 );
                append( sb, "Expression: ${promoteTransitiveDependencies}", 3 );
                append( sb, "", 0 );

                append( sb, "relocations", 2 );
                append( sb, "Packages to be relocated. For example:\n<relocations>\n\u00a0\u00a0<relocation>\n\u00a0\u00a0\u00a0\u00a0<pattern>org.apache</pattern>\n\u00a0\u00a0\u00a0\u00a0<shadedPattern>hidden.org.apache</shadedPattern>\n\u00a0\u00a0\u00a0\u00a0<includes>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<include>org.apache.maven.*</include>\n\u00a0\u00a0\u00a0\u00a0</includes>\n\u00a0\u00a0\u00a0\u00a0<excludes>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<exclude>org.apache.maven.Public*</exclude>\n\u00a0\u00a0\u00a0\u00a0</excludes>\n\u00a0\u00a0</relocation>\n</relocations>\nNote: Support for includes exists only since version 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "shadedArtifactAttached (Default: false)", 2 );
                append( sb, "Defines whether the shaded artifact should be attached as classifier to the original artifact. If false, the shaded jar will be the main artifact of the project", 3 );
                append( sb, "Expression: ${shadedArtifactAttached}", 3 );
                append( sb, "", 0 );

                append( sb, "shadedArtifactId (Default: ${project.artifactId})", 2 );
                append( sb, "The name of the shaded artifactId. So you may want to use a different artifactId and keep the standard version. If the original artifactId was \'foo\' then the final artifact would be something like foo-1.0.jar. So if you change the artifactId you might have something like foo-special-1.0.jar.", 3 );
                append( sb, "Expression: ${shadedArtifactId}", 3 );
                append( sb, "", 0 );

                append( sb, "shadedClassifierName (Default: shaded)", 2 );
                append( sb, "The name of the classifier used in case the shaded artifact is attached.", 3 );
                append( sb, "Expression: ${shadedClassifierName}", 3 );
                append( sb, "", 0 );

                append( sb, "shadedGroupFilter", 2 );
                append( sb, "If specified, this will include only artifacts which have groupIds which start with this.", 3 );
                append( sb, "Expression: ${shadedGroupFilter}", 3 );
                append( sb, "", 0 );

                append( sb, "transformers", 2 );
                append( sb, "Resource transformers to be used. Please see the \'Examples\' section for more information on available transformers and their configuration.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List<String> lines = new ArrayList<String>();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List<String> lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
