/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.surefire.report.PluginConsoleLogger;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.plugins.surefire.report.SurefireReportRenderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.utils.PathTool;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public abstract class AbstractSurefireReportMojo
extends AbstractMavenReport {
    @Parameter(defaultValue="true", required=true, property="showSuccess")
    private boolean showSuccess;
    @Parameter
    private File[] reportsDirectories;
    @Deprecated
    @Parameter
    private File reportsDirectory;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="true", property="linkXRef")
    private boolean linkXRef;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref-test")
    private File xrefLocation;
    @Parameter(defaultValue="false", property="aggregate")
    private boolean aggregate;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="${basedir}/src/site/custom/surefire-report.properties")
    private String customBundle;
    @Component
    private I18N i18n;
    private List<File> resolvedReportsDirectories;

    protected boolean isSkipped() {
        return false;
    }

    protected boolean isGeneratedWhenNoResults() {
        return false;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        SurefireReportRenderer r = new SurefireReportRenderer(this.getSink(), this.getI18N(locale), this.getI18Nsection(), locale, this.getConsoleLogger(), this.showSuccess, this.getReportsDirectories(), this.determineXrefLocation());
        r.render();
    }

    public boolean canGenerateReport() {
        if (this.isSkipped()) {
            return false;
        }
        List<File> reportsDirectories = this.getReportsDirectories();
        if (reportsDirectories == null) {
            return false;
        }
        if (!this.isGeneratedWhenNoResults()) {
            boolean atLeastOneDirectoryExists = false;
            Iterator<File> i = reportsDirectories.iterator();
            while (i.hasNext() && !atLeastOneDirectoryExists) {
                atLeastOneDirectoryExists = SurefireReportParser.hasReportFiles((File)i.next());
            }
            if (!atLeastOneDirectoryExists) {
                return false;
            }
        }
        return true;
    }

    private List<File> getReportsDirectories() {
        if (this.resolvedReportsDirectories != null) {
            return this.resolvedReportsDirectories;
        }
        this.resolvedReportsDirectories = new ArrayList<File>();
        if (this.reportsDirectories != null) {
            Collections.addAll(this.resolvedReportsDirectories, this.reportsDirectories);
        }
        if (this.reportsDirectory != null) {
            this.resolvedReportsDirectories.add(this.reportsDirectory);
        }
        if (this.aggregate) {
            if (!this.project.isExecutionRoot()) {
                return null;
            }
            if (this.reportsDirectories == null) {
                if (this.reactorProjects.size() > 1) {
                    for (MavenProject mavenProject : this.getProjectsWithoutRoot()) {
                        this.resolvedReportsDirectories.add(this.getSurefireReportsDirectory(mavenProject));
                    }
                } else {
                    this.resolvedReportsDirectories.add(this.getSurefireReportsDirectory(this.project));
                }
            } else {
                String parentBaseDir = this.getProject().getBasedir().getAbsolutePath();
                for (MavenProject subProject : this.getProjectsWithoutRoot()) {
                    String moduleBaseDir = subProject.getBasedir().getAbsolutePath();
                    for (File reportsDirectory1 : this.reportsDirectories) {
                        File reportsDirectory;
                        String reportDir = reportsDirectory1.getPath();
                        if (reportDir.startsWith(parentBaseDir)) {
                            reportDir = reportDir.substring(parentBaseDir.length());
                        }
                        if (!(reportsDirectory = new File(moduleBaseDir, reportDir)).exists() || !reportsDirectory.isDirectory()) continue;
                        this.getConsoleLogger().debug("Adding report dir: " + moduleBaseDir + reportDir);
                        this.resolvedReportsDirectories.add(reportsDirectory);
                    }
                }
            }
        } else if (this.resolvedReportsDirectories.isEmpty()) {
            this.resolvedReportsDirectories.add(this.getSurefireReportsDirectory(this.project));
        }
        return this.resolvedReportsDirectories;
    }

    protected abstract File getSurefireReportsDirectory(MavenProject var1);

    private List<MavenProject> getProjectsWithoutRoot() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject subProject : this.reactorProjects) {
            if (this.project.equals((Object)subProject)) continue;
            result.add(subProject);
        }
        return result;
    }

    private String determineXrefLocation() {
        String location = null;
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.getOutputDirectory(), (String)this.xrefLocation.getAbsolutePath());
            if (relativePath == null || relativePath.isEmpty()) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                location = relativePath;
            } else {
                for (Object o : this.project.getReportPlugins()) {
                    ReportPlugin report = (ReportPlugin)o;
                    String artifactId = report.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getConsoleLogger().warning("Unable to locate Test Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    protected String getI18nString(Locale locale, String key) {
        return this.getI18N(locale).getString("surefire-report", locale, "report." + this.getI18Nsection() + '.' + key);
    }

    protected I18N getI18N(Locale locale) {
        File customBundleFile;
        if (this.customBundle != null && (customBundleFile = new File(this.customBundle)).isFile() && customBundleFile.getName().endsWith(".properties") && (!this.i18n.getClass().isAssignableFrom(CustomI18N.class) || !this.i18n.getDefaultLanguage().equals(locale.getLanguage()))) {
            this.i18n = new CustomI18N(this.project, this.settings, customBundleFile, locale, this.i18n);
        }
        return this.i18n;
    }

    protected abstract String getI18Nsection();

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }

    public abstract String getOutputName();

    protected final ConsoleLogger getConsoleLogger() {
        return new PluginConsoleLogger(this.getLog());
    }

    protected MavenProject getProject() {
        return this.project;
    }

    private static class CustomI18N
    implements I18N {
        private final MavenProject project;
        private final Settings settings;
        private final String bundleName;
        private final Locale locale;
        private final I18N i18nOriginal;
        private ResourceBundle bundle;
        private static final Object[] NO_ARGS = new Object[0];

        CustomI18N(MavenProject project, Settings settings, File customBundleFile, Locale locale, I18N i18nOriginal) {
            this.project = project;
            this.settings = settings;
            this.locale = locale;
            this.i18nOriginal = i18nOriginal;
            this.bundleName = customBundleFile.getName().substring(0, customBundleFile.getName().indexOf(".properties"));
            URLClassLoader classLoader = null;
            try {
                classLoader = new URLClassLoader(new URL[]{customBundleFile.getParentFile().toURI().toURL()}, null);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.bundle = ResourceBundle.getBundle(this.bundleName, locale, classLoader);
            if (!this.bundle.getLocale().getLanguage().equals(locale.getLanguage())) {
                this.bundle = ResourceBundle.getBundle(this.bundleName, Locale.getDefault(), classLoader);
            }
        }

        public String getDefaultLanguage() {
            return this.locale.getLanguage();
        }

        public String getDefaultCountry() {
            return this.locale.getCountry();
        }

        public String getDefaultBundleName() {
            return this.bundleName;
        }

        public String[] getBundleNames() {
            return new String[]{this.bundleName};
        }

        public ResourceBundle getBundle() {
            return this.bundle;
        }

        public ResourceBundle getBundle(String bundleName) {
            return this.bundle;
        }

        public ResourceBundle getBundle(String bundleName, String languageHeader) {
            return this.bundle;
        }

        public ResourceBundle getBundle(String bundleName, Locale locale) {
            return this.bundle;
        }

        public Locale getLocale(String languageHeader) {
            return new Locale(languageHeader);
        }

        public String getString(String key) {
            return this.getString(this.bundleName, this.locale, key);
        }

        public String getString(String key, Locale locale) {
            return this.getString(this.bundleName, locale, key);
        }

        public String getString(String bundleName, Locale locale, String key) {
            ResourceBundle rb;
            String value;
            if (locale == null) {
                locale = this.getLocale(null);
            }
            if ((value = this.getStringOrNull(rb = this.getBundle(bundleName, locale), key)) == null) {
                value = this.i18nOriginal.getString(bundleName, locale, key);
            }
            if (!value.contains("${")) {
                return value;
            }
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            try {
                interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(this.project.getProperties()));
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("project", (Object)this.project));
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("pom", (Object)this.project));
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("settings", (Object)this.settings));
            try {
                value = interpolator.interpolate(value);
            }
            catch (InterpolationException interpolationException) {
                // empty catch block
            }
            return value;
        }

        public String format(String key, Object arg1) {
            return this.format(this.bundleName, this.locale, key, new Object[]{arg1});
        }

        public String format(String key, Object arg1, Object arg2) {
            return this.format(this.bundleName, this.locale, key, new Object[]{arg1, arg2});
        }

        public String format(String bundleName, Locale locale, String key, Object arg1) {
            return this.format(bundleName, locale, key, new Object[]{arg1});
        }

        public String format(String bundleName, Locale locale, String key, Object arg1, Object arg2) {
            return this.format(bundleName, locale, key, new Object[]{arg1, arg2});
        }

        public String format(String bundleName, Locale locale, String key, Object[] args) {
            if (locale == null) {
                locale = this.getLocale(null);
            }
            String value = this.getString(bundleName, locale, key);
            if (args == null) {
                args = NO_ARGS;
            }
            MessageFormat messageFormat = new MessageFormat("");
            messageFormat.setLocale(locale);
            messageFormat.applyPattern(value);
            return messageFormat.format(args);
        }

        private String getStringOrNull(ResourceBundle rb, String key) {
            if (rb != null) {
                try {
                    return rb.getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

