/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ExoTestng
extends AbstractMojo {
    protected MavenProject project;
    private File classesDirectory;
    private File testClassesDirectory;
    private String verbose;
    private String groups;
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        try {
            ArrayList<URL> classpaths = new ArrayList<URL>();
            classpaths.add(this.classesDirectory.toURL());
            classpaths.add(this.testClassesDirectory.toURL());
            Set artifacts = this.project.getArtifacts();
            for (Artifact da : artifacts) {
                classpaths.add(da.getFile().toURL());
            }
            URL[] urlpaths = new URL[classpaths.size()];
            classpaths.toArray(urlpaths);
            URLClassLoader newCL = new URLClassLoader(urlpaths, currentCL);
            Thread.currentThread().setContextClassLoader(newCL);
            if (this.verbose != null) {
                System.setProperty("testng.verbose", this.verbose);
            }
            if (this.groups != null) {
                System.setProperty("testng.groups", this.groups);
            }
            System.setProperty("basedir", this.project.getBasedir().toString());
            try {
                newCL.loadClass("org.exoplatform.util.TestNGRunner").newInstance();
            }
            catch (ClassNotFoundException ex) {
                System.err.println("\\n[ERROR] CANNOT RUN TESTNG , CLASS TestNGRunner NOT FOUND");
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Cannot run testng", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentCL);
        }
    }
}

