/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.io.File;
import java.io.IOException;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.war.AbstractWarMojo;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.war.WarArchiver;

public class WarMojo
extends AbstractWarMojo {
    private String outputDirectory;
    private String warName;
    private WarArchiver warArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException {
        File warFile = new File(this.outputDirectory, this.warName + ".war");
        try {
            this.performPackaging(warFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling WAR", e);
        }
    }

    private void performPackaging(File warFile) throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException {
        this.buildExplodedWebapp(this.getWebappDirectory());
        this.getLog().info((CharSequence)("Generating war " + warFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.warArchiver);
        archiver.setOutputFile(warFile);
        this.warArchiver.addDirectory(this.getWebappDirectory(), this.getIncludes(), this.getExcludes());
        this.warArchiver.setWebxml(new File(this.getWebappDirectory(), "WEB-INF/web.xml"));
        archiver.createArchive(this.getProject(), this.archive);
        this.getProject().getArtifact().setFile(warFile);
    }
}

