/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.wrapper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;

@Mojo(name="wrapper", aggregator=true, requiresDirectInvocation=true)
public class WrapperMojo
extends AbstractMojo {
    @Parameter(property="mavenVersion")
    private String mavenVersion;
    @Parameter(property="wrapperVersion")
    private String wrapperVersion;
    @Parameter(defaultValue="script", property="type")
    private String distributionType;
    @Parameter(defaultValue="true", property="includeDebug")
    private boolean includeDebugScript;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.basedir}")
    private File basedir;
    private String groupId = "org.apache.maven";
    private String artifactId = "apache-maven-wrapper";
    private String extension = "zip";
    @Inject
    private ArtifactResolver artifactResolver;
    @Inject
    private Map<String, UnArchiver> unarchivers;

    public void execute() throws MojoExecutionException {
        Artifact artifact;
        try {
            artifact = this.download();
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        try {
            this.unpack(artifact, this.basedir.toPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (this.mavenVersion != null) {
            try {
                this.replaceProperties(Files.createDirectories(this.basedir.toPath().resolve(".mvn/wrapper"), new FileAttribute[0]));
            }
            catch (IOException e) {
                throw new MojoExecutionException("can't create wrapper.proeprties", (Exception)e);
            }
        }
    }

    private Artifact download() throws ArtifactResolverException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(this.groupId);
        coordinate.setArtifactId(this.artifactId);
        coordinate.setVersion(this.getVersion(this.wrapperVersion));
        coordinate.setClassifier(this.distributionType);
        coordinate.setExtension(this.extension);
        return this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (ArtifactCoordinate)coordinate).getArtifact();
    }

    private void unpack(Artifact artifact, Path targetFolder) throws IOException {
        targetFolder = Files.createDirectories(targetFolder, new FileAttribute[0]);
        UnArchiver unarchiver = this.unarchivers.get(this.extension);
        unarchiver.setDestDirectory(targetFolder.toFile());
        unarchiver.setSourceFile(artifact.getFile());
        if (!this.includeDebugScript) {
            unarchiver.setFileSelectors(new FileSelector[]{f -> !f.getName().contains("Debug")});
        }
        unarchiver.extract();
    }

    private void replaceProperties(Path targetFolder) throws IOException {
        Path wrapperPropertiesFile = targetFolder.resolve("maven-wrapper.properties");
        String license = "# Licensed to the Apache Software Foundation (ASF) under one\n# or more contributor license agreements.  See the NOTICE file\n# distributed with this work for additional information\n# regarding copyright ownership.  The ASF licenses this file\n# to you under the Apache License, Version 2.0 (the\n# \"License\"); you may not use this file except in compliance\n# with the License.  You may obtain a copy of the License at\n# \n#   http://www.apache.org/licenses/LICENSE-2.0\n# \n# Unless required by applicable law or agreed to in writing,\n# software distributed under the License is distributed on an\n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n# KIND, either express or implied.  See the License for the\n# specific language governing permissions and limitations\n# under the License.\n";
        try (BufferedWriter out = Files.newBufferedWriter(wrapperPropertiesFile, new OpenOption[0]);){
            out.append("# Licensed to the Apache Software Foundation (ASF) under one\n# or more contributor license agreements.  See the NOTICE file\n# distributed with this work for additional information\n# regarding copyright ownership.  The ASF licenses this file\n# to you under the Apache License, Version 2.0 (the\n# \"License\"); you may not use this file except in compliance\n# with the License.  You may obtain a copy of the License at\n# \n#   http://www.apache.org/licenses/LICENSE-2.0\n# \n# Unless required by applicable law or agreed to in writing,\n# software distributed under the License is distributed on an\n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n# KIND, either express or implied.  See the License for the\n# specific language governing permissions and limitations\n# under the License.\n");
            out.append("distributionUrl=https://repo.maven.apache.org/maven2/org/apache/maven/apache-maven/" + this.mavenVersion + "/apache-maven-" + this.mavenVersion + "-bin.zip");
        }
    }

    private String getVersion(String defaultVersion) {
        String version = defaultVersion;
        if (version == null) {
            Properties props = new Properties();
            try (InputStream is = Maven.class.getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
                props.load(is);
                version = props.getProperty("version");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return version;
    }
}

