/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.wrapper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;

@Mojo(name="wrapper", aggregator=true, requiresDirectInvocation=true)
public class WrapperMojo
extends AbstractMojo {
    @Parameter(property="maven")
    private String mavenVersion;
    @Parameter(defaultValue="script", property="type")
    private String distributionType;
    @Parameter(defaultValue="true", property="includeDebug")
    private boolean includeDebugScript;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.basedir}", readonly=true, required=true)
    private File basedir;
    private static final String WRAPPER_DISTRIBUTION_GROUP_ID = "org.apache.maven.wrapper";
    private static final String WRAPPER_DISTRIBUTION_ARTIFACT_ID = "maven-wrapper-distribution";
    private static final String WRAPPER_DISTRIBUTION_EXTENSION = "zip";
    @Inject
    private ArtifactResolver artifactResolver;
    @Inject
    private Map<String, UnArchiver> unarchivers;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Artifact artifact;
        String wrapperVersion = this.getVersion(null, ((Object)((Object)this)).getClass(), "org.apache.maven.plugins/maven-wrapper-plugin");
        try {
            artifact = this.downloadWrapperDistribution(wrapperVersion);
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        try {
            this.unpack(artifact, this.basedir.toPath());
            this.getLog().info((CharSequence)("Unpacked " + MessageUtils.buffer().strong((Object)this.distributionType) + " type wrapper distribution " + artifact));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.mavenVersion = this.getVersion(this.mavenVersion, Maven.class, "org.apache.maven/maven-core");
        try {
            this.replaceProperties(wrapperVersion, Files.createDirectories(this.basedir.toPath().resolve(".mvn/wrapper"), new FileAttribute[0]));
        }
        catch (IOException e) {
            throw new MojoExecutionException("can't create maven-wrapper.properties", (Exception)e);
        }
    }

    private Artifact downloadWrapperDistribution(String wrapperVersion) throws ArtifactResolverException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(WRAPPER_DISTRIBUTION_GROUP_ID);
        coordinate.setArtifactId(WRAPPER_DISTRIBUTION_ARTIFACT_ID);
        coordinate.setVersion(wrapperVersion);
        coordinate.setClassifier(this.distributionType);
        coordinate.setExtension(WRAPPER_DISTRIBUTION_EXTENSION);
        return this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (ArtifactCoordinate)coordinate).getArtifact();
    }

    private void unpack(Artifact artifact, Path targetFolder) throws IOException {
        targetFolder = Files.createDirectories(targetFolder, new FileAttribute[0]);
        UnArchiver unarchiver = this.unarchivers.get(WRAPPER_DISTRIBUTION_EXTENSION);
        unarchiver.setDestDirectory(targetFolder.toFile());
        unarchiver.setSourceFile(artifact.getFile());
        if (!this.includeDebugScript) {
            unarchiver.setFileSelectors(new FileSelector[]{f -> !f.getName().contains("Debug")});
        }
        unarchiver.extract();
    }

    private void replaceProperties(String wrapperVersion, Path targetFolder) throws IOException {
        String repoUrl = "https://repo.maven.apache.org/maven2";
        String distributionUrl = repoUrl + "/org/apache/maven/apache-maven/" + this.mavenVersion + "/apache-maven-" + this.mavenVersion + "-bin.zip";
        String wrapperUrl = repoUrl + "/org/apache/maven/wrapper/maven-wrapper/" + wrapperVersion + "/maven-wrapper-" + wrapperVersion + ".zip";
        Path wrapperPropertiesFile = targetFolder.resolve("maven-wrapper.properties");
        this.getLog().info((CharSequence)("Configuring .mvn/wrapper/maven-wrapper.properties to use " + MessageUtils.buffer().strong((Object)("Maven " + this.mavenVersion)) + " and download from " + repoUrl));
        String license = "# Licensed to the Apache Software Foundation (ASF) under one\n# or more contributor license agreements.  See the NOTICE file\n# distributed with this work for additional information\n# regarding copyright ownership.  The ASF licenses this file\n# to you under the Apache License, Version 2.0 (the\n# \"License\"); you may not use this file except in compliance\n# with the License.  You may obtain a copy of the License at\n# \n#   http://www.apache.org/licenses/LICENSE-2.0\n# \n# Unless required by applicable law or agreed to in writing,\n# software distributed under the License is distributed on an\n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n# KIND, either express or implied.  See the License for the\n# specific language governing permissions and limitations\n# under the License.\n";
        try (BufferedWriter out = Files.newBufferedWriter(wrapperPropertiesFile, new OpenOption[0]);){
            out.append("# Licensed to the Apache Software Foundation (ASF) under one\n# or more contributor license agreements.  See the NOTICE file\n# distributed with this work for additional information\n# regarding copyright ownership.  The ASF licenses this file\n# to you under the Apache License, Version 2.0 (the\n# \"License\"); you may not use this file except in compliance\n# with the License.  You may obtain a copy of the License at\n# \n#   http://www.apache.org/licenses/LICENSE-2.0\n# \n# Unless required by applicable law or agreed to in writing,\n# software distributed under the License is distributed on an\n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n# KIND, either express or implied.  See the License for the\n# specific language governing permissions and limitations\n# under the License.\n");
            out.append("distributionUrl=" + distributionUrl + "\n");
            out.append("wrapperUrl=" + wrapperUrl + "\n");
        }
    }

    private String getVersion(String defaultVersion, Class<?> clazz, String path) {
        String version = defaultVersion;
        if (version == null) {
            Properties props = new Properties();
            try (InputStream is = clazz.getResourceAsStream("/META-INF/maven/" + path + "/pom.properties");){
                props.load(is);
                version = props.getProperty("version");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return version;
    }
}

