/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Scm;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.apache.maven.shared.release.config.ReleaseDescriptorStore;
import org.apache.maven.shared.release.config.ReleaseDescriptorStoreException;
import org.apache.maven.shared.release.config.ReleaseStageVersions;
import org.apache.maven.shared.release.config.ReleaseUtils;
import org.apache.maven.shared.release.scm.IdentifiedScm;
import org.apache.maven.shared.release.util.MavenCrypto;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="properties")
public class PropertiesReleaseDescriptorStore
implements ReleaseDescriptorStore {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MavenCrypto mavenCrypto;

    @Inject
    public PropertiesReleaseDescriptorStore(MavenCrypto mavenCrypto) {
        this.mavenCrypto = Objects.requireNonNull(mavenCrypto);
    }

    @Override
    public ReleaseDescriptorBuilder read(ReleaseDescriptorBuilder mergeDescriptor) throws ReleaseDescriptorStoreException {
        return this.read(mergeDescriptor, PropertiesReleaseDescriptorStore.getDefaultReleasePropertiesFile(mergeDescriptor.build()));
    }

    public ReleaseDescriptorBuilder read(File file) throws ReleaseDescriptorStoreException {
        return this.read(null, file);
    }

    public ReleaseDescriptorBuilder read(ReleaseDescriptorBuilder mergeDescriptor, File file) throws ReleaseDescriptorStoreException {
        Properties properties = new Properties();
        try (FileInputStream inStream = new FileInputStream(file);){
            properties.load(inStream);
        }
        catch (FileNotFoundException e) {
            this.logger.debug(file.getName() + " not found - using empty properties");
        }
        catch (IOException e) {
            throw new ReleaseDescriptorStoreException("Error reading properties file '" + file.getName() + "': " + e.getMessage(), e);
        }
        try {
            this.mavenCrypto.decryptProperties(properties);
        }
        catch (MavenCrypto.MavenCryptoException e) {
            this.logger.debug(e.getMessage());
        }
        ReleaseDescriptorBuilder builder = mergeDescriptor != null ? mergeDescriptor : new ReleaseDescriptorBuilder();
        ReleaseUtils.copyPropertiesToReleaseDescriptor(properties, builder);
        return builder;
    }

    @Override
    public void write(ReleaseDescriptor config) throws ReleaseDescriptorStoreException {
        this.write((ReleaseDescriptorBuilder.BuilderReleaseDescriptor)config, PropertiesReleaseDescriptorStore.getDefaultReleasePropertiesFile(config));
    }

    @Override
    public void delete(ReleaseDescriptor config) {
        File file = PropertiesReleaseDescriptorStore.getDefaultReleasePropertiesFile(config);
        if (file.exists()) {
            file.delete();
        }
    }

    public void write(ReleaseDescriptorBuilder.BuilderReleaseDescriptor config, File file) throws ReleaseDescriptorStoreException {
        Properties properties = new Properties();
        properties.setProperty("completedPhase", config.getCompletedPhase());
        if (config.isCommitByProject()) {
            properties.setProperty("commitByProject", "true");
        }
        properties.setProperty("scm.url", config.getScmSourceUrl());
        if (config.getScmId() != null) {
            properties.setProperty("scm.id", config.getScmId());
        }
        if (config.getScmUsername() != null) {
            properties.setProperty("scm.username", config.getScmUsername());
        }
        if (config.getScmPassword() != null) {
            String password = config.getScmPassword();
            try {
                password = this.mavenCrypto.encryptAndDecorate(password);
            }
            catch (MavenCrypto.MavenCryptoException mavenCryptoException) {
                this.logger.debug(mavenCryptoException.getMessage());
            }
            properties.setProperty("scm.password", password);
        }
        if (config.getScmPrivateKey() != null) {
            properties.setProperty("scm.privateKey", config.getScmPrivateKey());
        }
        if (config.getScmPrivateKeyPassPhrase() != null) {
            Iterator<Map.Entry<String, Scm>> passPhrase = config.getScmPrivateKeyPassPhrase();
            try {
                passPhrase = this.mavenCrypto.encryptAndDecorate((String)((Object)passPhrase));
            }
            catch (MavenCrypto.MavenCryptoException mavenCryptoException) {
                this.logger.debug(mavenCryptoException.getMessage());
            }
            properties.setProperty("scm.passphrase", (String)((Object)passPhrase));
        }
        if (config.getScmTagBase() != null) {
            properties.setProperty("scm.tagBase", config.getScmTagBase());
        }
        if (config.getScmBranchBase() != null) {
            properties.setProperty("scm.branchBase", config.getScmBranchBase());
        }
        if (config.getScmReleaseLabel() != null) {
            properties.setProperty("scm.tag", config.getScmReleaseLabel());
        }
        if (config.getScmTagNameFormat() != null) {
            properties.setProperty("scm.tagNameFormat", config.getScmTagNameFormat());
        }
        if (config.getScmCommentPrefix() != null) {
            properties.setProperty("scm.commentPrefix", config.getScmCommentPrefix());
        }
        if (config.getScmDevelopmentCommitComment() != null) {
            properties.setProperty("scm.developmentCommitComment", config.getScmDevelopmentCommitComment());
        }
        if (config.getScmReleaseCommitComment() != null) {
            properties.setProperty("scm.releaseCommitComment", config.getScmReleaseCommitComment());
        }
        if (config.getScmBranchCommitComment() != null) {
            properties.setProperty("scm.branchCommitComment", config.getScmBranchCommitComment());
        }
        if (config.getScmRollbackCommitComment() != null) {
            properties.setProperty("scm.rollbackCommitComment", config.getScmRollbackCommitComment());
        }
        if (config.getAdditionalArguments() != null) {
            properties.setProperty("exec.additionalArguments", config.getAdditionalArguments());
        }
        if (config.getPomFileName() != null) {
            properties.setProperty("exec.pomFileName", config.getPomFileName());
        }
        if (!config.getActivateProfiles().isEmpty()) {
            properties.setProperty("exec.activateProfiles", StringUtils.join(config.getActivateProfiles().iterator(), (String)","));
        }
        if (config.getPreparationGoals() != null) {
            properties.setProperty("preparationGoals", config.getPreparationGoals());
        }
        if (config.getCompletionGoals() != null) {
            properties.setProperty("completionGoals", config.getCompletionGoals());
        }
        if (config.getProjectVersionPolicyId() != null) {
            properties.setProperty("projectVersionPolicyId", config.getProjectVersionPolicyId());
        }
        if (config.getProjectNamingPolicyId() != null) {
            properties.setProperty("projectNamingPolicyId", config.getProjectNamingPolicyId());
        }
        if (config.getReleaseStrategyId() != null) {
            properties.setProperty("releaseStrategyId", config.getReleaseStrategyId());
        }
        properties.setProperty("exec.snapshotReleasePluginAllowed", Boolean.toString(config.isSnapshotReleasePluginAllowed()));
        properties.setProperty("remoteTagging", Boolean.toString(config.isRemoteTagging()));
        properties.setProperty("pinExternals", Boolean.toString(config.isPinExternals()));
        properties.setProperty("pushChanges", Boolean.toString(config.isPushChanges()));
        if (config.getWorkItem() != null) {
            properties.setProperty("workItem", config.getWorkItem());
        }
        if (config.getAutoResolveSnapshots() != null) {
            properties.setProperty("autoResolveSnapshots", config.getAutoResolveSnapshots());
        }
        for (Map.Entry entry : config.getProjectVersions().entrySet()) {
            if (((ReleaseStageVersions)entry.getValue()).getRelease() != null) {
                properties.setProperty("project.rel." + (String)entry.getKey(), ((ReleaseStageVersions)entry.getValue()).getRelease());
            }
            if (((ReleaseStageVersions)entry.getValue()).getDevelopment() == null) continue;
            properties.setProperty("project.dev." + (String)entry.getKey(), ((ReleaseStageVersions)entry.getValue()).getDevelopment());
        }
        for (Map.Entry<String, Scm> entry : config.getOriginalScmInfo().entrySet()) {
            Scm scm = entry.getValue();
            String prefix = "project.scm." + entry.getKey();
            if (scm != null) {
                IdentifiedScm identifiedScm;
                if (scm.getConnection() != null) {
                    properties.setProperty(prefix + ".connection", scm.getConnection());
                }
                if (scm.getDeveloperConnection() != null) {
                    properties.setProperty(prefix + ".developerConnection", scm.getDeveloperConnection());
                }
                if (scm.getUrl() != null) {
                    properties.setProperty(prefix + ".url", scm.getUrl());
                }
                if (scm.getTag() != null) {
                    properties.setProperty(prefix + ".tag", scm.getTag());
                }
                if (!(scm instanceof IdentifiedScm) || (identifiedScm = (IdentifiedScm)scm).getId() == null) continue;
                properties.setProperty(prefix + ".id", identifiedScm.getId());
                continue;
            }
            properties.setProperty(prefix + ".empty", "true");
        }
        if (config.getResolvedSnapshotDependencies() != null && config.getResolvedSnapshotDependencies().size() > 0) {
            this.processResolvedDependencies(properties, config.getResolvedSnapshotDependencies());
        }
        try {
            Throwable throwable = null;
            try (FileOutputStream outStream = new FileOutputStream(file);){
                properties.store(outStream, "release configuration");
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new ReleaseDescriptorStoreException("Error writing properties file '" + file.getName() + "': " + e.getMessage(), e);
        }
    }

    private void processResolvedDependencies(Properties prop, Map<String, ReleaseStageVersions> resolvedDependencies) {
        for (Map.Entry<String, ReleaseStageVersions> currentEntry : resolvedDependencies.entrySet()) {
            ReleaseStageVersions versionMap = currentEntry.getValue();
            prop.setProperty("dependency." + currentEntry.getKey() + ".release", versionMap.getRelease());
            prop.setProperty("dependency." + currentEntry.getKey() + ".development", versionMap.getDevelopment());
        }
    }

    private static File getDefaultReleasePropertiesFile(ReleaseDescriptor mergeDescriptor) {
        return new File(mergeDescriptor.getWorkingDirectory(), "release.properties");
    }
}

