/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.policy.oddeven;

import java.util.List;
import org.apache.maven.shared.release.policy.PolicyException;
import org.apache.maven.shared.release.policy.version.VersionPolicy;
import org.apache.maven.shared.release.policy.version.VersionPolicyRequest;
import org.apache.maven.shared.release.policy.version.VersionPolicyResult;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

@Component(role=VersionPolicy.class, hint="OddEvenVersionPolicy", description="A VersionPolicy implementation that allows release even version numbers")
public final class OddEvenVersionPolicy
implements VersionPolicy {
    public VersionPolicyResult getReleaseVersion(VersionPolicyRequest request) throws PolicyException {
        return this.calculateNextVersion(request, false);
    }

    public VersionPolicyResult getDevelopmentVersion(VersionPolicyRequest request) throws PolicyException {
        return this.calculateNextVersion(request, true);
    }

    private VersionPolicyResult calculateNextVersion(VersionPolicyRequest request, boolean development) {
        DefaultVersionInfo defaultVersionInfo = null;
        try {
            defaultVersionInfo = new DefaultVersionInfo(request.getVersion());
        }
        catch (VersionParseException e) {
            throw new IllegalArgumentException("Can't tell if version with no digits is even: " + e.getMessage(), e);
        }
        int versionNumbersToSkip = 1;
        if (development && !this.isEven(defaultVersionInfo)) {
            versionNumbersToSkip = 2;
        }
        if (!development && this.isEven(defaultVersionInfo)) {
            versionNumbersToSkip = 0;
        }
        DefaultVersionInfo suggestedVersionInfo = defaultVersionInfo;
        while (versionNumbersToSkip != 0) {
            suggestedVersionInfo = suggestedVersionInfo.getNextVersion();
            --versionNumbersToSkip;
        }
        String nextVersion = development ? suggestedVersionInfo.getSnapshotVersionString() : suggestedVersionInfo.getReleaseVersionString();
        return new VersionPolicyResult().setVersion(nextVersion);
    }

    private boolean isEven(DefaultVersionInfo defaultVersionInfo) {
        int mostSignificantSegment;
        if (StringUtils.isNumeric((String)defaultVersionInfo.getAnnotationRevision())) {
            mostSignificantSegment = Integer.parseInt(defaultVersionInfo.getAnnotationRevision());
        } else {
            List digits = defaultVersionInfo.getDigits();
            if (digits == null) {
                throw new IllegalArgumentException("Can't tell if version with no digits is even.");
            }
            mostSignificantSegment = Integer.parseInt((String)digits.get(digits.size() - 1));
        }
        return mostSignificantSegment % 2 == 0;
    }
}

