/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect.bf;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.internal.impl.collect.DataPool;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.internal.impl.collect.PremanagedDependency;
import org.eclipse.aether.internal.impl.collect.bf.DependencyProcessingContext;
import org.eclipse.aether.internal.impl.collect.bf.DependencyResolutionSkipper;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.version.Version;

@Singleton
@Named(value="bf")
public class BfDependencyCollector
extends DependencyCollectorDelegate
implements Service {
    public static final String NAME = "bf";
    public static final String CONFIG_PROP_SKIPPER = "aether.dependencyCollector.bf.skipper";
    public static final boolean CONFIG_PROP_SKIPPER_DEFAULT = true;

    @Deprecated
    public BfDependencyCollector() {
    }

    @Inject
    BfDependencyCollector(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        super(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver);
    }

    @Override
    protected void doCollectDependencies(RepositorySystemSession session, RequestTrace trace, DataPool pool, DefaultDependencyCollectionContext context, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyNode node, List<RemoteRepository> repositories, List<Dependency> dependencies, List<Dependency> managedDependencies, DependencyCollectorDelegate.Results results) {
        boolean useSkip = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{CONFIG_PROP_SKIPPER});
        if (useSkip) {
            this.logger.debug("Collector skip mode enabled");
        }
        Args args = new Args(session, pool, context, versionContext, request, useSkip ? DependencyResolutionSkipper.defaultSkipper() : DependencyResolutionSkipper.neverSkipper());
        DependencySelector rootDepSelector = session.getDependencySelector() != null ? session.getDependencySelector().deriveChildSelector((DependencyCollectionContext)context) : null;
        DependencyManager rootDepManager = session.getDependencyManager() != null ? session.getDependencyManager().deriveChildManager((DependencyCollectionContext)context) : null;
        DependencyTraverser rootDepTraverser = session.getDependencyTraverser() != null ? session.getDependencyTraverser().deriveChildTraverser((DependencyCollectionContext)context) : null;
        VersionFilter rootVerFilter = session.getVersionFilter() != null ? session.getVersionFilter().deriveChildFilter((DependencyCollectionContext)context) : null;
        List<DependencyNode> parents = Collections.singletonList(node);
        for (Dependency dependency : dependencies) {
            args.dependencyProcessingQueue.add(new DependencyProcessingContext(rootDepSelector, rootDepManager, rootDepTraverser, rootVerFilter, repositories, managedDependencies, parents, dependency));
        }
        while (!args.dependencyProcessingQueue.isEmpty()) {
            this.processDependency(args, trace, results, args.dependencyProcessingQueue.remove(), Collections.emptyList(), false);
        }
        args.skipper.report();
    }

    private void processDependency(Args args, RequestTrace parent, DependencyCollectorDelegate.Results results, DependencyProcessingContext context, List<Artifact> relocations, boolean disableVersionManagement) {
        List<? extends Version> versions;
        VersionRangeResult rangeResult;
        if (context.depSelector != null && !context.depSelector.selectDependency(context.dependency)) {
            return;
        }
        RequestTrace trace = this.collectStepTrace(parent, args.request.getRequestContext(), context.parents, context.dependency);
        PremanagedDependency preManaged = PremanagedDependency.create(context.depManager, context.dependency, disableVersionManagement, args.premanagedState);
        Dependency dependency = preManaged.getManagedDependency();
        boolean noDescriptor = BfDependencyCollector.isLackingDescriptor(dependency.getArtifact());
        boolean traverse = !noDescriptor && (context.depTraverser == null || context.depTraverser.traverseDependency(dependency));
        try {
            VersionRangeRequest rangeRequest = BfDependencyCollector.createVersionRangeRequest(args.request.getRequestContext(), trace, context.repositories, dependency);
            rangeResult = this.cachedResolveRangeResult(rangeRequest, args.pool, args.session);
            versions = BfDependencyCollector.filterVersions(dependency, rangeResult, context.verFilter, args.versionContext);
        }
        catch (VersionRangeResolutionException e) {
            results.addException(dependency, (Exception)((Object)e), context.parents);
            return;
        }
        Collections.reverse(versions);
        for (Version version : versions) {
            ArtifactDescriptorResult descriptorResult;
            Artifact originalArtifact = dependency.getArtifact().setVersion(version.toString());
            Dependency d = dependency.setArtifact(originalArtifact);
            ArtifactDescriptorRequest descriptorRequest = BfDependencyCollector.createArtifactDescriptorRequest(args.request.getRequestContext(), trace, context.repositories, d);
            ArtifactDescriptorResult artifactDescriptorResult = descriptorResult = noDescriptor ? new ArtifactDescriptorResult(descriptorRequest) : this.resolveCachedArtifactDescriptor(args.pool, descriptorRequest, args.session, context.withDependency(d), results);
            if (descriptorResult != null) {
                DefaultDependencyNode child;
                int cycleEntry = DefaultDependencyCycle.find(context.parents, (d = d.setArtifact(descriptorResult.getArtifact())).getArtifact());
                if (cycleEntry >= 0) {
                    results.addCycle(context.parents, cycleEntry, d);
                    DependencyNode cycleNode = context.parents.get(cycleEntry);
                    if (cycleNode.getDependency() != null) {
                        child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult, cycleNode);
                        context.getParent().getChildren().add(child);
                        continue;
                    }
                }
                if (!descriptorResult.getRelocations().isEmpty()) {
                    boolean disableVersionManagementSubsequently = originalArtifact.getGroupId().equals(d.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d.getArtifact().getArtifactId());
                    this.processDependency(args, parent, results, context.withDependency(d), descriptorResult.getRelocations(), disableVersionManagementSubsequently);
                    return;
                }
                d = args.pool.intern(d.setArtifact(args.pool.intern(d.getArtifact())));
                List<RemoteRepository> repos = BfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), context.repositories);
                child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), repos, args.request.getRequestContext());
                context.getParent().getChildren().add(child);
                boolean recurse = traverse && !descriptorResult.getDependencies().isEmpty();
                DependencyProcessingContext parentContext = context.withDependency(d);
                if (recurse) {
                    this.doRecurse(args, parentContext, descriptorResult, child);
                    continue;
                }
                if (args.skipper.skipResolution((DependencyNode)child, parentContext.parents)) continue;
                ArrayList<DependencyNode> parents = new ArrayList<DependencyNode>(parentContext.parents.size() + 1);
                parents.addAll(parentContext.parents);
                parents.add((DependencyNode)child);
                args.skipper.cache((DependencyNode)child, parents);
                continue;
            }
            List<RemoteRepository> repos = BfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), context.repositories);
            DefaultDependencyNode child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, null, repos, args.request.getRequestContext());
            context.getParent().getChildren().add(child);
        }
    }

    private void doRecurse(Args args, DependencyProcessingContext parentContext, ArtifactDescriptorResult descriptorResult, DefaultDependencyNode child) {
        DefaultDependencyCollectionContext context = args.collectionContext;
        context.set(parentContext.dependency, descriptorResult.getManagedDependencies());
        DependencySelector childSelector = parentContext.depSelector != null ? parentContext.depSelector.deriveChildSelector((DependencyCollectionContext)context) : null;
        DependencyManager childManager = parentContext.depManager != null ? parentContext.depManager.deriveChildManager((DependencyCollectionContext)context) : null;
        DependencyTraverser childTraverser = parentContext.depTraverser != null ? parentContext.depTraverser.deriveChildTraverser((DependencyCollectionContext)context) : null;
        VersionFilter childFilter = parentContext.verFilter != null ? parentContext.verFilter.deriveChildFilter((DependencyCollectionContext)context) : null;
        List<RemoteRepository> childRepos = args.ignoreRepos ? parentContext.repositories : this.remoteRepositoryManager.aggregateRepositories(args.session, parentContext.repositories, descriptorResult.getRepositories(), true);
        Object key = args.pool.toKey(parentContext.dependency.getArtifact(), childRepos, childSelector, childManager, childTraverser, childFilter);
        List<DependencyNode> children = args.pool.getChildren(key);
        if (children == null) {
            boolean skipResolution = args.skipper.skipResolution((DependencyNode)child, parentContext.parents);
            if (!skipResolution) {
                ArrayList<DependencyNode> parents = new ArrayList<DependencyNode>(parentContext.parents.size() + 1);
                parents.addAll(parentContext.parents);
                parents.add((DependencyNode)child);
                for (Dependency dependency : descriptorResult.getDependencies()) {
                    args.dependencyProcessingQueue.add(new DependencyProcessingContext(childSelector, childManager, childTraverser, childFilter, childRepos, descriptorResult.getManagedDependencies(), parents, dependency));
                }
                args.pool.putChildren(key, child.getChildren());
                args.skipper.cache((DependencyNode)child, parents);
            }
        } else {
            child.setChildren(children);
        }
    }

    private ArtifactDescriptorResult resolveCachedArtifactDescriptor(DataPool pool, ArtifactDescriptorRequest descriptorRequest, RepositorySystemSession session, DependencyProcessingContext context, DependencyCollectorDelegate.Results results) {
        Object key = pool.toKey(descriptorRequest);
        ArtifactDescriptorResult descriptorResult = pool.getDescriptor(key, descriptorRequest);
        if (descriptorResult == null) {
            try {
                descriptorResult = this.descriptorReader.readArtifactDescriptor(session, descriptorRequest);
                pool.putDescriptor(key, descriptorResult);
            }
            catch (ArtifactDescriptorException e) {
                results.addException(context.dependency, (Exception)((Object)e), context.parents);
                pool.putDescriptor(key, e);
                return null;
            }
        } else if (descriptorResult == DataPool.NO_DESCRIPTOR) {
            return null;
        }
        return descriptorResult;
    }

    static class Args {
        final RepositorySystemSession session;
        final boolean ignoreRepos;
        final boolean premanagedState;
        final DataPool pool;
        final Queue<DependencyProcessingContext> dependencyProcessingQueue = new ArrayDeque<DependencyProcessingContext>(128);
        final DefaultDependencyCollectionContext collectionContext;
        final DefaultVersionFilterContext versionContext;
        final CollectRequest request;
        final DependencyResolutionSkipper skipper;

        Args(RepositorySystemSession session, DataPool pool, DefaultDependencyCollectionContext collectionContext, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyResolutionSkipper skipper) {
            this.session = session;
            this.request = request;
            this.ignoreRepos = session.isIgnoreArtifactDescriptorRepositories();
            this.premanagedState = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{"aether.dependencyManager.verbose"});
            this.pool = pool;
            this.collectionContext = collectionContext;
            this.versionContext = versionContext;
            this.skipper = skipper;
        }
    }
}

