/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.scm.ChangeFile;

public class ChangeSet {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat TIMESTAMP_FORMAT_1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final SimpleDateFormat TIMESTAMP_FORMAT_2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Date date;
    private String author;
    private String comment = "";
    private ChangeFile file;

    public ChangeSet(String date, String comment, String author, ChangeFile file) {
        this.setDate(date);
        this.setAuthor(author);
        this.setComment(comment);
        this.file = file;
    }

    public ChangeSet() {
    }

    public ChangeFile getFile() {
        return this.file;
    }

    public void setFile(ChangeFile file) {
        this.file = file;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getDate() {
        return (Date)this.date.clone();
    }

    public void setDate(Date date) {
        this.date = new Date(date.getTime());
    }

    public void setDate(String date) {
        try {
            this.date = TIMESTAMP_FORMAT_1.parse(date);
        }
        catch (ParseException e) {
            try {
                this.date = TIMESTAMP_FORMAT_2.parse(date);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Unable to parse CVS date: " + date);
            }
        }
    }

    public synchronized String getDateFormatted() {
        return DATE_FORMAT.format(this.getDate());
    }

    public synchronized String getTimeFormatted() {
        return TIME_FORMAT.format(this.getDate());
    }

    public String toString() {
        return this.author + "\n" + this.date + "\n" + this.file + "\n" + this.comment;
    }

    public boolean equals(Object obj) {
        ChangeSet changeSet;
        return obj instanceof ChangeSet && this.date.equals((changeSet = (ChangeSet)obj).getDate()) && this.author.equals(changeSet.getAuthor()) && this.comment.equals(changeSet.getComment()) && this.file.equals(changeSet.getFile());
    }
}

