/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.command.changelog;

import java.util.Date;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;

public abstract class AbstractChangeLogCommand
extends AbstractCommand
implements ChangeLogCommand {
    protected abstract ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository var1, ScmFileSet var2, Date var3, Date var4, int var5, String var6) throws ScmException;

    public ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        Date startDate = parameters.getDate(CommandParameter.START_DATE, null);
        Date endDate = parameters.getDate(CommandParameter.END_DATE, null);
        int numDays = parameters.getInt(CommandParameter.NUM_DAYS, 0);
        String branch = parameters.getString(CommandParameter.BRANCH, null);
        if (numDays != 0 && (startDate != null || endDate != null)) {
            throw new ScmException("Start or end date cannot be set if num days is set.");
        }
        if (endDate != null && startDate == null) {
            throw new ScmException("The end date is set but the start date isn't.");
        }
        return this.executeChangeLogCommand(repository, fileSet, startDate, endDate, numDays, branch);
    }
}

