/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.login.LoginScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.add.CvsAddCommand;
import org.apache.maven.scm.provider.cvslib.command.changelog.CvsChangeLogCommand;
import org.apache.maven.scm.provider.cvslib.command.checkin.CvsCheckInCommand;
import org.apache.maven.scm.provider.cvslib.command.checkout.CvsCheckOutCommand;
import org.apache.maven.scm.provider.cvslib.command.diff.CvsDiffCommand;
import org.apache.maven.scm.provider.cvslib.command.login.CvsLoginCommand;
import org.apache.maven.scm.provider.cvslib.command.remove.CvsRemoveCommand;
import org.apache.maven.scm.provider.cvslib.command.status.CvsStatusCommand;
import org.apache.maven.scm.provider.cvslib.command.tag.CvsTagCommand;
import org.apache.maven.scm.provider.cvslib.command.update.CvsUpdateCommand;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class CvsScmProvider
extends AbstractScmProvider {
    private static final String TRANSPORT_LOCAL = "local";
    private static final String TRANSPORT_PSERVER = "pserver";
    private static final String TRANSPORT_LSERVER = "lserver";
    private static final String TRANSPORT_EXT = "ext";

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        ScmUrlParserResult result = this.parseScmUrl(scmSpecificUrl, delimiter);
        if (result.messages.size() > 0) {
            throw new ScmRepositoryException("The scm url is invalid.", result.messages);
        }
        return result.repository;
    }

    public ScmProviderRepository makeProviderScmRepository(File path) throws ScmRepositoryException, UnknownRepositoryStructure {
        String module;
        String cvsRoot;
        if (path == null || !path.isDirectory()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a valid directory.");
        }
        File cvsDirectory = new File(path, "CVS");
        if (!cvsDirectory.exists()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a cvs checkout directory.");
        }
        File cvsRootFile = new File(cvsDirectory, "Root");
        File moduleFile = new File(cvsDirectory, "Repository");
        try {
            cvsRoot = FileUtils.fileRead((File)cvsRootFile).trim().substring(1);
        }
        catch (IOException e) {
            throw new ScmRepositoryException("Can't read " + cvsRootFile.getAbsolutePath());
        }
        try {
            module = FileUtils.fileRead((File)moduleFile).trim();
        }
        catch (IOException e) {
            throw new ScmRepositoryException("Can't read " + moduleFile.getAbsolutePath());
        }
        return this.makeProviderScmRepository(cvsRoot + ":" + module, ':');
    }

    public List validateScmUrl(String scmSpecificUrl, char delimiter) {
        ScmUrlParserResult result = this.parseScmUrl(scmSpecificUrl, delimiter);
        return result.messages;
    }

    public String getScmType() {
        return "cvs";
    }

    private ScmUrlParserResult parseScmUrl(String scmSpecificUrl, char delimiter) {
        String cvsroot;
        ScmUrlParserResult result = new ScmUrlParserResult();
        String[] tokens = StringUtils.split((String)scmSpecificUrl, (String)Character.toString(delimiter));
        if (tokens.length < 3) {
            result.messages.add("The connection string contains to few tokens.");
            return result;
        }
        String transport = tokens[0];
        if (transport.equalsIgnoreCase(TRANSPORT_LOCAL)) {
            cvsroot = tokens[1];
        } else if (transport.equalsIgnoreCase(TRANSPORT_PSERVER) || transport.equalsIgnoreCase(TRANSPORT_LSERVER) || transport.equalsIgnoreCase(TRANSPORT_EXT)) {
            if (tokens.length != 4 && transport.equalsIgnoreCase(TRANSPORT_EXT)) {
                result.messages.add("The connection string contains to few tokens.");
                return result;
            }
            if ((tokens.length < 4 || tokens.length > 6) && transport.equalsIgnoreCase(TRANSPORT_PSERVER)) {
                result.messages.add("The connection string contains to few tokens.");
                return result;
            }
            if (tokens.length < 4 || tokens.length > 5 && !transport.equalsIgnoreCase(TRANSPORT_PSERVER)) {
                result.messages.add("The connection string contains to few tokens.");
                return result;
            }
            cvsroot = transport.equalsIgnoreCase(TRANSPORT_LSERVER) ? tokens[1] + ":" + tokens[2] : (tokens.length == 4 ? ":" + transport + ":" + tokens[1] + ":" + tokens[2] : ":" + transport + ":" + tokens[1] + ":" + tokens[2] + ":" + tokens[3]);
        } else {
            result.messages.add("Unknown transport: " + transport);
            return result;
        }
        String user = null;
        String password = null;
        String host = null;
        String path = null;
        String module = null;
        int port = -1;
        if (transport.equalsIgnoreCase(TRANSPORT_PSERVER)) {
            String passhost;
            String userhost;
            if (tokens.length == 4) {
                userhost = tokens[1];
                int index = userhost.indexOf("@");
                if (index == -1) {
                    result.messages.add("The userhost part must be on the form: <username>@<hostname>.");
                    return result;
                }
                user = userhost.substring(0, index);
                host = userhost.substring(index + 1);
                path = tokens[2];
                module = tokens[3];
            } else if (tokens.length == 6) {
                user = tokens[1];
                passhost = tokens[2];
                int index = passhost.indexOf("@");
                if (index == -1) {
                    result.messages.add("The user_password_host part must be on the form: <username>:<password>@<hostname>.");
                    return result;
                }
                password = passhost.substring(0, index);
                host = passhost.substring(index + 1);
                port = new Integer(tokens[3]);
                path = tokens[4];
                module = tokens[5];
            } else {
                if (tokens[1].indexOf("@") > 0) {
                    userhost = tokens[1];
                    int index = userhost.indexOf("@");
                    if (index == -1) {
                        result.messages.add("The userhost part must be on the form: <username>@<hostname>.");
                        return result;
                    }
                    user = userhost.substring(0, index);
                    host = userhost.substring(index + 1);
                    port = new Integer(tokens[2]);
                } else if (tokens[2].indexOf("@") > 0) {
                    user = tokens[1];
                    passhost = tokens[2];
                    int index = passhost.indexOf("@");
                    if (index == -1) {
                        result.messages.add("The user_password_host part must be on the form: <username>:<password>@<hostname>.");
                        return result;
                    }
                    password = passhost.substring(0, index);
                    host = passhost.substring(index + 1);
                } else {
                    result.messages.add("You need to specify an user in the url.");
                    return result;
                }
                path = tokens[3];
                module = tokens[4];
            }
            String userHostPort = host;
            if (user != null) {
                userHostPort = user + "@" + host;
            }
            if (port != -1) {
                userHostPort = userHostPort + ":" + port;
            }
            cvsroot = ":" + transport + ":" + userHostPort + ":" + path;
        } else {
            if (!transport.equalsIgnoreCase(TRANSPORT_LOCAL)) {
                String userhost = tokens[1];
                int index = userhost.indexOf("@");
                if (index == -1) {
                    result.messages.add("The userhost part must be on the form: <username>@<hostname>.");
                    return result;
                }
                user = userhost.substring(0, index);
                host = userhost.substring(index + 1);
            }
            if (transport.equals(TRANSPORT_LOCAL)) {
                path = tokens[1];
                module = tokens[2];
            } else if (tokens.length == 4) {
                path = tokens[2];
                module = tokens[3];
            } else {
                port = new Integer(tokens[2]);
                path = tokens[3];
                module = tokens[4];
            }
        }
        result.repository = port == -1 ? new CvsScmProviderRepository(cvsroot, transport, user, password, host, path, module) : new CvsScmProviderRepository(cvsroot, transport, user, password, host, port, path, module);
        return result;
    }

    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsAddCommand command = new CvsAddCommand();
        command.setLogger(this.getLogger());
        return (AddScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public ChangeLogScmResult changelog(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsChangeLogCommand command = new CvsChangeLogCommand();
        command.setLogger(this.getLogger());
        return (ChangeLogScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public CheckInScmResult checkin(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsCheckInCommand command = new CvsCheckInCommand();
        command.setLogger(this.getLogger());
        return (CheckInScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public CheckOutScmResult checkout(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsCheckOutCommand command = new CvsCheckOutCommand();
        command.setLogger(this.getLogger());
        return (CheckOutScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsDiffCommand command = new CvsDiffCommand();
        command.setLogger(this.getLogger());
        return (DiffScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public LoginScmResult login(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsLoginCommand command = new CvsLoginCommand();
        command.setLogger(this.getLogger());
        return (LoginScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public RemoveScmResult remove(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsRemoveCommand command = new CvsRemoveCommand();
        command.setLogger(this.getLogger());
        return (RemoveScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public StatusScmResult status(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsStatusCommand command = new CvsStatusCommand();
        command.setLogger(this.getLogger());
        return (StatusScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsTagCommand command = new CvsTagCommand();
        command.setLogger(this.getLogger());
        return (TagScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsUpdateCommand command = new CvsUpdateCommand();
        command.setLogger(this.getLogger());
        return (UpdateScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    private static class ScmUrlParserResult {
        List messages = new ArrayList();
        ScmProviderRepository repository;

        private ScmUrlParserResult() {
        }
    }
}

