/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.changelog;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.changelog.CvsChangeLogConsumer;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsChangeLogCommand
extends AbstractChangeLogCommand
implements CvsCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, String branch) throws ScmException {
        int exitCode;
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        if (numDays > 0) {
            startDate = new Date(System.currentTimeMillis() - (long)numDays * 24L * 60L * 60L * 1000L);
            endDate = new Date(System.currentTimeMillis() + 86400000L);
        }
        Commandline cl = new Commandline();
        cl.setExecutable("cvs");
        cl.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
        cl.createArgument().setValue("-f");
        cl.createArgument().setValue("-d");
        cl.createArgument().setValue(repository.getCvsRoot());
        cl.createArgument().setValue("-q");
        cl.createArgument().setValue("log");
        if (startDate != null) {
            SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd");
            String dateRange = endDate == null ? ">" + outputDate.format(startDate) : outputDate.format(startDate) + "<" + outputDate.format(endDate);
            cl.createArgument().setValue("-d " + dateRange);
        }
        if (branch != null) {
            cl.createArgument().setValue("-r" + branch);
        }
        CvsChangeLogConsumer consumer = new CvsChangeLogConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().debug("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        this.getLogger().debug("Command line: " + cl);
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing cvs command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new ChangeLogScmResult(cl.toString(), "The cvs command failed.", stderr.getOutput(), false);
        }
        return new ChangeLogScmResult(cl.toString(), consumer.getModifications());
    }
}

