/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.changelog;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsChangeLogConsumer
implements StreamConsumer {
    private List entries = new ArrayList();
    private static final int GET_FILE = 1;
    private static final int GET_DATE = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_REVISION = 4;
    private static final String START_FILE = "Working file: ";
    private static final String END_FILE = "=============================================================================";
    private static final String START_REVISION = "----------------------------";
    private static final String REVISION_TAG = "revision ";
    private static final String DATE_TAG = "date: ";
    private int status = 1;
    private ChangeSet currentChange = null;
    private ChangeFile currentFile = null;
    private ScmLogger logger;

    public CvsChangeLogConsumer(ScmLogger logger) {
        this.logger = logger;
    }

    public List getModifications() {
        return this.entries;
    }

    public void consumeLine(String line) {
        try {
            switch (this.getStatus()) {
                case 1: {
                    this.processGetFile(line);
                    break;
                }
                case 4: {
                    this.processGetRevision(line);
                    break;
                }
                case 2: {
                    this.processGetDate(line);
                    break;
                }
                case 3: {
                    this.processGetComment(line);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + this.status);
                }
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Exception in the cvs changelog consumer.", ex);
        }
    }

    private void addEntry(ChangeSet entry, ChangeFile file) {
        if (entry.getAuthor() == null) {
            return;
        }
        entry.setFile(file);
        this.entries.add(entry);
    }

    private void processGetFile(String line) {
        if (line.startsWith(START_FILE)) {
            this.setCurrentChange(new ChangeSet());
            this.setCurrentFile(new ChangeFile(line.substring(START_FILE.length(), line.length())));
            this.setStatus(4);
        }
    }

    private void processGetRevision(String line) {
        if (line.startsWith(REVISION_TAG)) {
            this.getCurrentFile().setRevision(line.substring(REVISION_TAG.length()));
            this.setStatus(2);
        } else if (line.startsWith(END_FILE)) {
            this.setStatus(1);
            this.addEntry(this.getCurrentChange(), this.getCurrentFile());
        }
    }

    private void processGetDate(String line) {
        if (line.startsWith(DATE_TAG)) {
            StringTokenizer tokenizer = new StringTokenizer(line, " ;");
            tokenizer.nextToken();
            String date = tokenizer.nextToken();
            String time = tokenizer.nextToken();
            this.getCurrentChange().setDate(date + " " + time);
            tokenizer.nextToken();
            String author = tokenizer.nextToken();
            this.getCurrentChange().setAuthor(author);
            this.setStatus(3);
        }
    }

    private void processGetComment(String line) {
        if (line.startsWith(START_REVISION)) {
            this.addEntry(this.getCurrentChange(), this.getCurrentFile());
            this.setCurrentChange(new ChangeSet());
            this.setCurrentFile(new ChangeFile(this.getCurrentFile().getName()));
            this.setStatus(4);
        } else if (line.startsWith(END_FILE)) {
            this.addEntry(this.getCurrentChange(), this.getCurrentFile());
            this.setStatus(1);
        } else {
            this.getCurrentChange().setComment(this.getCurrentChange().getComment() + line + "\n");
        }
    }

    private ChangeFile getCurrentFile() {
        return this.currentFile;
    }

    private void setCurrentFile(ChangeFile currentFile) {
        this.currentFile = currentFile;
    }

    private ChangeSet getCurrentChange() {
        return this.currentChange;
    }

    private void setCurrentChange(ChangeSet currentChange) {
        this.currentChange = currentChange;
    }

    private int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
    }
}

