/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.diff;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.diff.AbstractDiffCommand;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.diff.CvsDiffConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsDiffCommand
extends AbstractDiffCommand
implements CvsCommand {
    protected DiffScmResult executeDiffCommand(ScmProviderRepository repo, ScmFileSet fileSet, String startRevision, String endRevision) throws ScmException {
        Commandline cl = CvsDiffCommand.createCommandLine(fileSet.getBasedir(), startRevision, endRevision);
        CvsDiffConsumer consumer = new CvsDiffConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        this.getLogger().debug("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        this.getLogger().debug("Command line: " + cl);
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        return new DiffScmResult(cl.toString(), consumer.getChangedFiles(), consumer.getDifferences(), consumer.getPatch());
    }

    public static Commandline createCommandLine(File workingDirectory, String startRevision, String endRevision) {
        Commandline cl = new Commandline();
        cl.setExecutable("cvs");
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        cl.createArgument().setValue("-q");
        cl.createArgument().setValue("-f");
        cl.createArgument().setValue("diff");
        cl.createArgument().setValue("-u");
        cl.createArgument().setValue("-N");
        if (startRevision != null) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(startRevision);
        }
        if (endRevision != null) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(endRevision);
        }
        return cl;
    }
}

