/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.remove;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsRemoveCommand
extends AbstractRemoveCommand
implements CvsCommand {
    protected ScmResult executeRemoveCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message) throws ScmException {
        int exitCode;
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = new Commandline();
        cl.setExecutable("cvs");
        cl.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
        cl.createArgument().setValue("-f");
        cl.createArgument().setValue("-d");
        cl.createArgument().setValue(repository.getCvsRoot());
        cl.createArgument().setValue("-q");
        cl.createArgument().setValue("remove");
        cl.createArgument().setValue("-f");
        cl.createArgument().setValue("-l");
        if (message != null && message.length() > 0) {
            cl.createArgument().setValue("-m");
            cl.createArgument().setValue("\"" + message + "\"");
        }
        File[] files = fileSet.getFiles();
        ArrayList<ScmFile> removedFiles = new ArrayList<ScmFile>();
        for (int i = 0; i < files.length; ++i) {
            String path = files[i].getPath().replace('\\', '/');
            cl.createArgument().setValue(path);
            removedFiles.add(new ScmFile(path, ScmFileStatus.DELETED));
        }
        CommandLineUtils.StringStreamConsumer consumer = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().debug("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        this.getLogger().debug("Command line: " + cl);
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new RemoveScmResult(cl.toString(), "The cvs command failed.", stderr.getOutput(), false);
        }
        return new RemoveScmResult(cl.toString(), removedFiles);
    }
}

