/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.update;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.util.AbstractConsumer;

public class GitLatestRevisionCommandConsumer
extends AbstractConsumer {
    private static final Pattern LATESTREV_PATTERN = Pattern.compile("^commit \\s*(.*)");
    private String latestRevision;

    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GitLatestRevisionCommandConsumer consumeLine : " + line);
        }
        if (line == null || StringUtils.isEmpty((CharSequence)line)) {
            return;
        }
        this.processGetLatestRevision(line);
    }

    public String getLatestRevision() {
        return this.latestRevision;
    }

    private void processGetLatestRevision(String line) {
        Matcher matcher = LATESTREV_PATTERN.matcher(line);
        if (matcher.matches()) {
            this.latestRevision = matcher.group(1);
        }
    }
}

