/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgChangeLogConsumer
extends HgConsumer {
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    private static final String REVNO_TAG = "changeset: ";
    private static final String TAG_TAG = "tag:         ";
    private static final String AUTHOR_TAG = "user: ";
    private static final String TIME_STAMP_TOKEN = "date: ";
    private static final String MESSAGE_TOKEN = "description:";
    private static final String FILES_TOKEN = "files: ";
    private String prevLine = "";
    private String prevPrevLine = "";
    private List<ChangeSet> logEntries = new ArrayList<ChangeSet>();
    private ChangeSet currentChange;
    private String currentRevision;
    private String currentTag;
    private String userDatePattern;
    private boolean spoolingComments;
    private List<String> currentComment = null;

    public HgChangeLogConsumer(ScmLogger logger, String userDatePattern) {
        super(logger);
        this.userDatePattern = userDatePattern;
    }

    public List<ChangeSet> getModifications() {
        return this.logEntries;
    }

    @Override
    public void consumeLine(String line) {
        this.doConsume(null, line);
    }

    @Override
    public void doConsume(ScmFileStatus status, String line) {
        int i;
        String tmpLine = line;
        if (line.equals("") && this.prevLine.equals("") && this.prevPrevLine.equals("") || this.currentComment == null) {
            if (this.currentComment != null) {
                StringBuilder comment = new StringBuilder();
                for (i = 0; i < this.currentComment.size() - 1; ++i) {
                    comment.append(this.currentComment.get(i));
                    if (i + 1 >= this.currentComment.size() - 1) continue;
                    comment.append('\n');
                }
                this.currentChange.setComment(comment.toString());
            }
            this.spoolingComments = false;
            this.currentChange = new ChangeSet();
            this.currentChange.setFiles(new ArrayList(0));
            this.logEntries.add(this.currentChange);
            this.currentComment = new ArrayList<String>();
            this.currentRevision = "";
        }
        if (this.spoolingComments) {
            this.currentComment.add(line);
        } else if (line.startsWith(MESSAGE_TOKEN)) {
            this.spoolingComments = true;
        } else if (line.startsWith(REVNO_TAG)) {
            tmpLine = line.substring(REVNO_TAG.length());
            tmpLine = tmpLine.trim();
            this.currentRevision = tmpLine.substring(tmpLine.indexOf(58) + 1);
            this.currentChange.setRevision(this.currentRevision);
        } else if (line.startsWith(TAG_TAG)) {
            this.currentTag = tmpLine = line.substring(TAG_TAG.length()).trim();
        } else if (line.startsWith(AUTHOR_TAG)) {
            tmpLine = line.substring(AUTHOR_TAG.length());
            tmpLine = tmpLine.trim();
            this.currentChange.setAuthor(tmpLine);
        } else if (line.startsWith(TIME_STAMP_TOKEN)) {
            tmpLine = line.substring(TIME_STAMP_TOKEN.length()).trim();
            Date date = this.parseDate(tmpLine, this.userDatePattern, TIME_PATTERN, Locale.ENGLISH);
            this.currentChange.setDate(date);
        } else if (line.startsWith(FILES_TOKEN)) {
            tmpLine = line.substring(FILES_TOKEN.length()).trim();
            String[] files = tmpLine.split(" ");
            for (i = 0; i < files.length; ++i) {
                String file = files[i];
                ChangeFile changeFile = new ChangeFile(file, this.currentRevision);
                this.currentChange.addFile(changeFile);
            }
        } else if (line.length() > 0 && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Could not figure out: " + line);
        }
        this.prevPrevLine = this.prevLine = line;
    }
}

