/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.changelog;

import java.io.File;
import java.util.Date;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.changelog.StarteamChangeLogConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class StarteamChangeLogCommand
extends AbstractChangeLogCommand
implements StarteamCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, String branch) throws ScmException {
        int exitCode;
        if (startDate != null || endDate != null) {
            throw new ScmException("This provider doesn't support start and end dates.");
        }
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        Commandline cl = StarteamChangeLogCommand.createCommandLine(repository, fileSet.getBasedir(), branch);
        StarteamChangeLogConsumer consumer = new StarteamChangeLogConsumer(this.getLogger(), startDate, endDate);
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        this.getLogger().debug("Command line: " + cl);
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new ChangeLogScmResult(cl.toString(), "The 'stcmd' command failed.", stderr.getOutput(), false);
        }
        return new ChangeLogScmResult(cl.toString(), consumer.getModifications());
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, File workingDirectory, String tag) {
        String workingDir = workingDirectory.getAbsolutePath();
        Commandline cl = StarteamCommandLineUtils.createStarteamBaseCommandLine("hist", workingDirectory, repo);
        cl.createArgument().setValue("-is");
        if (tag != null && tag.length() != 0) {
            cl.createArgument().setValue("-cfgl");
            cl.createArgument().setValue(tag);
        }
        return cl;
    }
}

