/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.add;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.command.add.SvnAddConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnAddCommand
extends AbstractAddCommand
implements SvnCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        int exitCode;
        if (binary) {
            throw new ScmException("This provider does not yet support binary files");
        }
        if (fileSet.getFiles().length == 0) {
            throw new ScmException("You must provide at least one file/directory to add");
        }
        Commandline cl = SvnAddCommand.createCommandLine(fileSet.getBasedir(), fileSet.getFiles());
        SvnAddConsumer consumer = new SvnAddConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        this.getLogger().info("Command line: " + cl);
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new AddScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new AddScmResult(cl.toString(), consumer.getAddedFiles());
    }

    private static Commandline createCommandLine(File workingDirectory, File[] files) {
        Commandline cl = new Commandline();
        cl.setExecutable("svn");
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        cl.createArgument().setValue("add");
        cl.createArgument().setValue("--non-recursive");
        SvnCommandLineUtils.addFiles(cl, files);
        return cl;
    }
}

