/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.changelog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnChangeLogConsumer
implements StreamConsumer {
    private static final SimpleDateFormat SVN_TIMESTAMP = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzzzzzzzz");
    private static final int GET_HEADER = 1;
    private static final int GET_FILE = 2;
    private static final int GET_COMMENT = 3;
    private static final String FILE_BEGIN_TOKEN = " ";
    private static final String FILE_END_TOKEN = "";
    private static final int FILE_START_INDEX = 5;
    private static final String COMMENT_END_TOKEN = "------------------------------------------------------------------------";
    private static final String pattern = "^rev (\\d+):\\s+(\\w+)\\s+\\|\\s+(\\d+-\\d+-\\d+ \\d+:\\d+:\\d+) ([\\-+])(\\d\\d)(\\d\\d)";
    private int status = 1;
    private List entries = new ArrayList();
    private ChangeSet currentChange;
    private String currentRevision;
    private StringBuffer currentComment;
    private RE headerRegexp;

    public SvnChangeLogConsumer() {
        try {
            this.headerRegexp = new RE(pattern);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse svn log file. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    public List getModifications() {
        return this.entries;
    }

    public void consumeLine(String line) {
        switch (this.status) {
            case 1: {
                this.processGetHeader(line);
                break;
            }
            case 2: {
                this.processGetFile(line);
                break;
            }
            case 3: {
                this.processGetComment(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + this.status);
            }
        }
    }

    private void processGetHeader(String line) {
        if (!this.headerRegexp.match(line)) {
            return;
        }
        this.currentRevision = this.headerRegexp.getParen(1);
        this.currentChange = new ChangeSet();
        this.currentChange.setAuthor(this.headerRegexp.getParen(2));
        this.currentChange.setDate(this.parseDate());
        this.status = 2;
    }

    private void processGetFile(String line) {
        if (line.startsWith(FILE_BEGIN_TOKEN)) {
            String name = line.substring(5);
            this.currentChange.setFile(new ChangeFile(name, this.currentRevision));
            this.status = 2;
        } else if (line.equals(FILE_END_TOKEN)) {
            this.currentComment = new StringBuffer();
            this.status = 3;
        }
    }

    private void processGetComment(String line) {
        if (line.equals(COMMENT_END_TOKEN)) {
            this.currentChange.setComment(this.currentComment.toString());
            this.entries.add(this.currentChange);
            this.status = 1;
        } else {
            this.currentComment.append(line).append('\n');
        }
    }

    private Date parseDate() {
        try {
            StringBuffer date = new StringBuffer().append(this.headerRegexp.getParen(3)).append(" GMT").append(this.headerRegexp.getParen(4)).append(this.headerRegexp.getParen(5)).append(':').append(this.headerRegexp.getParen(6));
            return SVN_TIMESTAMP.parse(date.toString());
        }
        catch (ParseException e) {
            return null;
        }
    }
}

