/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.checkin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.command.checkin.SvnCheckInConsumer;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnCheckInCommand
extends AbstractCheckInCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, String tag) throws ScmException {
        int exitCode;
        if (!StringUtils.isEmpty((String)tag)) {
            throw new ScmException("This provider can't handle tags.");
        }
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)message);
        }
        catch (IOException ex) {
            return new CheckInScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        Commandline cl = SvnCheckInCommand.createCommandLine((SvnScmProviderRepository)repo, fileSet, messageFile);
        SvnCheckInConsumer consumer = new SvnCheckInConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        this.getLogger().info("Command line: " + cl);
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException ex) {}
        }
        if (exitCode != 0) {
            return new CheckInScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new CheckInScmResult(cl.toString(), consumer.getCheckedInFiles());
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, ScmFileSet fileSet, File messageFile) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(fileSet.getBasedir(), repository);
        cl.createArgument().setValue("commit");
        cl.createArgument().setValue("--file");
        cl.createArgument().setValue(messageFile.getAbsolutePath());
        SvnCommandLineUtils.addFiles(cl, fileSet.getFiles());
        return cl;
    }
}

