/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.checkout;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.command.checkout.SvnCheckOutConsumer;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnCheckOutCommand
extends AbstractCheckOutCommand
implements SvnCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag) throws ScmException {
        int exitCode;
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        String url = repository.getUrl();
        if (tag != null) {
            String tagBase = repository.getTagBase();
            if (tagBase == null) {
                throw new ScmException("tag base must be specified");
            }
            url = tagBase + "/" + tag;
        }
        Commandline cl = SvnCheckOutCommand.createCommandLine(repository, fileSet.getBasedir(), null, url);
        SvnCheckOutConsumer consumer = new SvnCheckOutConsumer(this.getLogger(), fileSet.getBasedir().getParentFile());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        this.getLogger().info("Command line: " + cl);
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new CheckOutScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(cl.toString(), consumer.getCheckedOutFiles());
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String revision, String url) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory.getParentFile(), repository);
        cl.createArgument().setValue("checkout");
        if (revision != null) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(revision);
        }
        cl.createArgument().setValue(url);
        cl.createArgument().setValue(workingDirectory.getName());
        return cl;
    }
}

