/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.checkout;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnCheckOutConsumer
implements StreamConsumer {
    private static final String CHECKED_OUT_REVISION_TOKEN = "Checked out revision";
    private ScmLogger logger;
    private File workingDirectory;
    private List checkedOutFiles = new ArrayList();
    private int revision;

    public SvnCheckOutConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
        this.workingDirectory = workingDirectory;
    }

    public void consumeLine(String line) {
        ScmFileStatus status;
        this.logger.debug(line);
        if (line.length() <= 3) {
            this.logger.warn("Unexpected input, the line must be at least three characters long. Line: '" + line + "'.");
            return;
        }
        String statusString = line.substring(0, 1);
        String file = line.substring(3).trim();
        if (line.startsWith(CHECKED_OUT_REVISION_TOKEN)) {
            String revisionString = line.substring(CHECKED_OUT_REVISION_TOKEN.length() + 1, line.length() - 1);
            try {
                this.revision = Integer.parseInt(revisionString);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            return;
        }
        if (statusString.equals("A")) {
            status = ScmFileStatus.ADDED;
        } else if (statusString.equals("U")) {
            status = ScmFileStatus.UPDATED;
        } else {
            this.logger.info("Unknown file status: '" + statusString + "'.");
            return;
        }
        if (!new File(this.workingDirectory, file).isFile()) {
            this.logger.debug("Skipping non-file: " + file);
            return;
        }
        this.checkedOutFiles.add(new ScmFile(file, status));
    }

    public List getCheckedOutFiles() {
        return this.checkedOutFiles;
    }

    public int getRevision() {
        return this.revision;
    }
}

