/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.repository;

import org.apache.maven.scm.provider.ScmProviderRepository;

public class SvnScmProviderRepository
extends ScmProviderRepository {
    private String url;
    private String tagBase;

    public SvnScmProviderRepository(String url, String user, String password) {
        this.tagBase = url.substring(0, url.lastIndexOf(47)) + "/tags";
        this.setUser(user);
        this.setPassword(password);
        this.parseUrl(url);
    }

    public String getUrl() {
        return this.url;
    }

    public String getTagBase() {
        return this.tagBase;
    }

    public void setTagBase(String tagBase) {
        this.tagBase = tagBase;
    }

    private void parseUrl(String url) {
        String protocol = null;
        if (url.startsWith("file")) {
            protocol = "file://";
        } else if (url.startsWith("https")) {
            protocol = "https://";
        } else if (url.startsWith("http")) {
            protocol = "http://";
        } else if (url.startsWith("svn+ssh")) {
            protocol = "svn+ssh://";
        } else if (url.startsWith("svn")) {
            protocol = "svn://";
        }
        String urlPath = url.substring(protocol.length());
        int indexAt = urlPath.indexOf("@");
        if (indexAt > 0 && !"svn+ssh://".equals(protocol)) {
            this.setUser(urlPath.substring(0, indexAt));
            this.url = protocol + urlPath.substring(indexAt + 1);
        } else {
            this.url = protocol + urlPath;
        }
    }
}

