/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.util;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.provider.svn.util.Entry;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class EntriesReader {
    public List read(Reader reader) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        ArrayList<Entry> entries = new ArrayList<Entry>();
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("entry")) {
                        entries.add(this.parseEntry("entry", (XmlPullParser)parser));
                        continue;
                    }
                    parser.nextText();
                }
            }
            eventType = parser.next();
        }
        return entries;
    }

    private Entry parseEntry(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Entry entry = new Entry();
        entry.setName(this.getTrimmedValue(parser.getAttributeValue("", "name")));
        entry.setUrl(this.getTrimmedValue(parser.getAttributeValue("", "url")));
        return entry;
    }

    public int getIntegerValue(String s) {
        if (s != null) {
            return Integer.valueOf(s);
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }
}

