/*
 * $Id$
 */

package org.apache.maven.shared.model.fileset.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.Mapper;
import org.apache.maven.shared.model.fileset.SetBase;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class FileSetXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class FileSetXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param fileSet
     * @throws java.io.IOException
     */
    public void write(Writer writer, FileSet fileSet)
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( fileSet.getModelEncoding(), null );
        writeFileSet( fileSet, "fileSet", serializer );
        serializer.endDocument();
    } //-- void write(Writer, FileSet) 

    /**
     * Method writeFileSet.
     * 
     * @param fileSet
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( fileSet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( fileSet.getDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "directory" ).text( fileSet.getDirectory() ).endTag( NAMESPACE, "directory" );
            }
            if ( fileSet.getLineEnding() != null )
            {
                serializer.startTag( NAMESPACE, "lineEnding" ).text( fileSet.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
            }
            if ( fileSet.isFollowSymlinks() != false )
            {
                serializer.startTag( NAMESPACE, "followSymlinks" ).text( String.valueOf( fileSet.isFollowSymlinks() ) ).endTag( NAMESPACE, "followSymlinks" );
            }
            if ( fileSet.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( fileSet.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( fileSet.isUseDefaultExcludes() != false )
            {
                serializer.startTag( NAMESPACE, "useDefaultExcludes" ).text( String.valueOf( fileSet.isUseDefaultExcludes() ) ).endTag( NAMESPACE, "useDefaultExcludes" );
            }
            if ( fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = fileSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = fileSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( fileSet.getFileMode() != null && !fileSet.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( fileSet.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( fileSet.getDirectoryMode() != null && !fileSet.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( fileSet.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            if ( fileSet.getMapper() != null )
            {
                writeMapper( (Mapper) fileSet.getMapper(), "mapper", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeFileSet(FileSet, String, XmlSerializer) 

    /**
     * Method writeMapper.
     * 
     * @param mapper
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeMapper(Mapper mapper, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( mapper != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( mapper.getType() != null && !mapper.getType().equals( "identity" ) )
            {
                serializer.startTag( NAMESPACE, "type" ).text( mapper.getType() ).endTag( NAMESPACE, "type" );
            }
            if ( mapper.getFrom() != null )
            {
                serializer.startTag( NAMESPACE, "from" ).text( mapper.getFrom() ).endTag( NAMESPACE, "from" );
            }
            if ( mapper.getTo() != null )
            {
                serializer.startTag( NAMESPACE, "to" ).text( mapper.getTo() ).endTag( NAMESPACE, "to" );
            }
            if ( mapper.getClassname() != null )
            {
                serializer.startTag( NAMESPACE, "classname" ).text( mapper.getClassname() ).endTag( NAMESPACE, "classname" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeMapper(Mapper, String, XmlSerializer) 

    /**
     * Method writeSetBase.
     * 
     * @param setBase
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeSetBase(SetBase setBase, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( setBase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( setBase.isFollowSymlinks() != false )
            {
                serializer.startTag( NAMESPACE, "followSymlinks" ).text( String.valueOf( setBase.isFollowSymlinks() ) ).endTag( NAMESPACE, "followSymlinks" );
            }
            if ( setBase.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( setBase.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( setBase.isUseDefaultExcludes() != false )
            {
                serializer.startTag( NAMESPACE, "useDefaultExcludes" ).text( String.valueOf( setBase.isUseDefaultExcludes() ) ).endTag( NAMESPACE, "useDefaultExcludes" );
            }
            if ( setBase.getIncludes() != null && setBase.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = setBase.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( setBase.getExcludes() != null && setBase.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = setBase.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( setBase.getFileMode() != null && !setBase.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( setBase.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( setBase.getDirectoryMode() != null && !setBase.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( setBase.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            if ( setBase.getMapper() != null )
            {
                writeMapper( (Mapper) setBase.getMapper(), "mapper", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeSetBase(SetBase, String, XmlSerializer) 


}
