/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.collect.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.shared.dependency.collect.CollectorResult;
import org.apache.maven.shared.dependency.collect.internal.Maven31ArtifactRepositoryAdapter;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;

public class Maven31CollectorResult
implements CollectorResult {
    private final CollectResult collectResult;

    public Maven31CollectorResult(CollectResult collectResult) {
        this.collectResult = collectResult;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        final HashSet aetherRepositories = new HashSet();
        DependencyVisitor visitor = new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                aetherRepositories.addAll(node.getRepositories());
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        };
        this.collectResult.getRoot().accept(visitor);
        ArrayList<ArtifactRepository> mavenRepositories = new ArrayList<ArtifactRepository>(aetherRepositories.size());
        for (RemoteRepository aetherRepository : aetherRepositories) {
            mavenRepositories.add(new Maven31ArtifactRepositoryAdapter(aetherRepository));
        }
        return mavenRepositories;
    }
}

