/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.resolve.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.resolve.FilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.EclipseAetherFilterTransformer;
import org.apache.maven.shared.dependency.DependencyCoordinate;
import org.apache.maven.shared.dependency.resolve.DependencyResolver;
import org.apache.maven.shared.dependency.resolve.DependencyResolverException;
import org.apache.maven.shared.dependency.resolve.internal.Invoker;
import org.apache.maven.shared.dependency.resolve.internal.Maven31ArtifactResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

@Component(role=DependencyResolver.class, hint="maven31")
public class Maven31DependencyResolver
implements DependencyResolver {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public Iterable<org.apache.maven.shared.artifact.resolve.ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, DependencyCoordinate coordinate, TransformableFilter dependencyFilter) throws DependencyResolverException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        Dependency aetherRoot = Maven31DependencyResolver.toDependency(coordinate, typeRegistry);
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, (Object)buildingRequest.getRemoteRepositories());
        CollectRequest request = new CollectRequest(aetherRoot, aetherRepositories);
        return this.resolveDependencies(buildingRequest, aetherRepositories, dependencyFilter, request);
    }

    @Override
    public Iterable<org.apache.maven.shared.artifact.resolve.ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, Collection<org.apache.maven.model.Dependency> mavenDependencies, Collection<org.apache.maven.model.Dependency> managedMavenDependencies, TransformableFilter filter) throws DependencyResolverException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        Class[] argClasses = new Class[]{org.apache.maven.model.Dependency.class, ArtifactTypeRegistry.class};
        ArrayList<Dependency> aetherDeps = null;
        if (mavenDependencies != null) {
            aetherDeps = new ArrayList<Dependency>(mavenDependencies.size());
            for (org.apache.maven.model.Dependency mavenDependency : mavenDependencies) {
                Object[] args = new Object[]{mavenDependency, typeRegistry};
                Dependency aetherDependency = (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
                aetherDeps.add(aetherDependency);
            }
        }
        ArrayList<Dependency> aetherManagedDependencies = null;
        if (managedMavenDependencies != null) {
            aetherManagedDependencies = new ArrayList<Dependency>(managedMavenDependencies.size());
            for (org.apache.maven.model.Dependency mavenDependency : managedMavenDependencies) {
                Object[] args = new Object[]{mavenDependency, typeRegistry};
                Dependency aetherDependency = (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
                aetherManagedDependencies.add(aetherDependency);
            }
        }
        List aetherRepos = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, (Object)buildingRequest.getRemoteRepositories());
        CollectRequest request = new CollectRequest(aetherDeps, aetherManagedDependencies, aetherRepos);
        return this.resolveDependencies(buildingRequest, aetherRepos, filter, request);
    }

    private Iterable<org.apache.maven.shared.artifact.resolve.ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, List<RemoteRepository> aetherRepositories, TransformableFilter dependencyFilter, CollectRequest request) throws DependencyResolverException {
        try {
            DependencyFilter depFilter = null;
            if (dependencyFilter != null) {
                depFilter = (DependencyFilter)dependencyFilter.transform((FilterTransformer)new EclipseAetherFilterTransformer());
            }
            DependencyRequest depRequest = new DependencyRequest(request, depFilter);
            RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
            DependencyResult dependencyResults = this.repositorySystem.resolveDependencies(session, depRequest);
            ArrayList<ArtifactRequest> artifactRequests = new ArrayList<ArtifactRequest>(dependencyResults.getArtifactResults().size());
            for (ArtifactResult artifactResult : dependencyResults.getArtifactResults()) {
                artifactRequests.add(new ArtifactRequest(artifactResult.getArtifact(), aetherRepositories, null));
            }
            final List artifactResults = this.repositorySystem.resolveArtifacts(session, artifactRequests);
            return new Iterable<org.apache.maven.shared.artifact.resolve.ArtifactResult>(){

                @Override
                public Iterator<org.apache.maven.shared.artifact.resolve.ArtifactResult> iterator() {
                    ArrayList<Maven31ArtifactResult> artResults = new ArrayList<Maven31ArtifactResult>(artifactResults.size());
                    for (ArtifactResult artifactResult : artifactResults) {
                        artResults.add(new Maven31ArtifactResult(artifactResult));
                    }
                    return artResults.iterator();
                }
            };
        }
        catch (ArtifactResolutionException e) {
            throw new DependencyResolverException(e.getMessage(), (Exception)((Object)e));
        }
        catch (DependencyResolutionException e) {
            throw new DependencyResolverException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static Dependency toDependency(DependencyCoordinate coordinate, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(coordinate.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(coordinate.getType());
        }
        DefaultArtifact artifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), null, coordinate.getVersion(), null, stereotype);
        return new Dependency((Artifact)artifact, null);
    }
}

