/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.util.internal.DumpFileUtils;

public final class DumpErrorSingleton {
    private static final String DUMP_FILE_EXT = ".dump";
    private static final String DUMPSTREAM_FILE_EXT = ".dumpstream";
    private static final DumpErrorSingleton SINGLETON = new DumpErrorSingleton();
    private File dumpFile;
    private File dumpStreamFile;

    private DumpErrorSingleton() {
    }

    public static DumpErrorSingleton getSingleton() {
        return SINGLETON;
    }

    public synchronized void init(String dumpFileName, ReporterConfiguration configuration) {
        this.dumpFile = this.createDumpFile(dumpFileName, configuration);
        this.dumpStreamFile = this.createDumpStreamFile(dumpFileName, configuration);
    }

    public synchronized void dumpException(Throwable t, String msg) {
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, this.dumpFile);
    }

    public synchronized void dumpException(Throwable t) {
        DumpFileUtils.dumpException(t, this.dumpFile);
    }

    public synchronized void dumpText(String msg) {
        DumpFileUtils.dumpText(msg == null ? "null" : msg, this.dumpFile);
    }

    public synchronized void dumpStreamException(Throwable t, String msg) {
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, this.dumpStreamFile);
    }

    public synchronized void dumpStreamException(Throwable t) {
        DumpFileUtils.dumpException(t, this.dumpStreamFile);
    }

    public synchronized void dumpStreamText(String msg) {
        DumpFileUtils.dumpText(msg == null ? "null" : msg, this.dumpStreamFile);
    }

    private File createDumpFile(String dumpFileName, ReporterConfiguration configuration) {
        return DumpFileUtils.newDumpFile(dumpFileName + DUMP_FILE_EXT, configuration);
    }

    private File createDumpStreamFile(String dumpFileName, ReporterConfiguration configuration) {
        return DumpFileUtils.newDumpFile(dumpFileName + DUMPSTREAM_FILE_EXT, configuration);
    }
}

