/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;

public class CategorizedReportEntry
extends SimpleReportEntry
implements ReportEntry {
    private static final String GROUP_PREFIX = " (of ";
    private static final String GROUP_SUFIX = ")";
    private final String group;

    public CategorizedReportEntry(String source, String name, String group) {
        this(source, name, group, null, null);
    }

    public CategorizedReportEntry(String source, String name, String group, StackTraceWriter stackTraceWriter, Integer elapsed) {
        super(source, name, stackTraceWriter, elapsed);
        this.group = group;
    }

    public CategorizedReportEntry(String source, String name, String group, StackTraceWriter stackTraceWriter, Integer elapsed, String message) {
        super(source, name, stackTraceWriter, elapsed, message);
        this.group = group;
    }

    public static ReportEntry reportEntry(String source, String name, String group, StackTraceWriter stackTraceWriter, Integer elapsed, String message) {
        return group != null ? new CategorizedReportEntry(source, name, group, stackTraceWriter, elapsed, message) : new SimpleReportEntry(source, name, stackTraceWriter, elapsed, message);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getNameWithGroup() {
        return this.isNameWithGroup() ? this.getName() + GROUP_PREFIX + this.getGroup() + GROUP_SUFIX : this.getName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategorizedReportEntry that = (CategorizedReportEntry)o;
        return !(this.group == null ? that.group != null : !this.group.equals(that.group));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        return result;
    }

    private boolean isNameWithGroup() {
        return this.getGroup() != null && !this.getGroup().equals(this.getName());
    }
}

