/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.surefire.ForkingWriterStreamConsumer;
import org.apache.maven.surefire.IsolatedClassLoader;
import org.apache.maven.surefire.Surefire;
import org.apache.maven.surefire.SurefireBooterForkException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SurefireBooter {
    protected static final String EOL = System.getProperty("line.separator");
    protected static final String PS = System.getProperty("path.separator");
    private static final String RUNNER = "org.apache.maven.surefire.SurefireBooter";
    private static final String BATTERY_EXECUTOR = "org.apache.maven.surefire.Surefire";
    private static final String SINGLE_TEST_BATTERY = "org.apache.maven.surefire.battery.JUnitBattery";
    private List batteries = new ArrayList();
    private List reports = new ArrayList();
    private List classpathUrls = new ArrayList();
    private String reportsDirectory;
    private String forkMode;
    private String basedir;
    private String jvm;
    private Properties systemProperties;
    private String argLine;
    private Map environmentVariables;
    private File workingDirectory;
    private boolean childDelegation;
    private boolean debug;
    private String surefireBooterJar;
    private String plexusUtilsJar;
    public static final String FORK_ONCE = "once";
    public static final String FORK_PERTEST = "pertest";
    public static final String FORK_NONE = "none";
    public static final String SUREFIRE_PROPERTIES = "surefire.properties";
    public static final String SYSTEM_PROPERTIES = "surefire-system.properties";
    public static final String CLASSLOADER_PROPERTIES = "surefire-classloader.properties";
    static int TESTS_SUCCEEDED = 0;
    static int TESTS_FAILED = 255;
    static int ILLEGAL_ARGUMENT_EXCEPTION = 100;
    static int OTHER_EXCEPTION = 200;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$String;

    public void setReportsDirectory(String reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public String getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void addBattery(String battery, Object[] params) {
        this.batteries.add(new Object[]{battery, params});
    }

    public void addBattery(String battery) {
        this.batteries.add(new Object[]{battery, null});
    }

    public void addReport(String report) {
        this.reports.add(report);
    }

    public void addClassPathUrl(String path) {
        if (!this.classpathUrls.contains(path)) {
            this.classpathUrls.add(path);
        }
    }

    public void setClassPathUrls(List classpathUrls) {
        this.classpathUrls = classpathUrls;
    }

    public void setForkMode(String forkMode) {
        if (!(forkMode.equals(FORK_NONE) || forkMode.equals(FORK_ONCE) || forkMode.equals(FORK_PERTEST))) {
            throw new IllegalArgumentException("Fork mode " + forkMode + " is not a legal value");
        }
        this.forkMode = forkMode;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    public void setEnvironmentVariables(Map environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setWorkingDirectory(File dir) {
        this.workingDirectory = dir;
    }

    public void setChildDelegation(boolean childDelegation) {
        this.childDelegation = childDelegation;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean run() throws Exception {
        boolean result = false;
        if (this.forkMode.equals(FORK_NONE)) {
            result = this.runTestsInProcess();
        } else if (this.forkMode.equals(FORK_ONCE)) {
            result = this.runTestsForkOnce();
        } else if (this.forkMode.equals(FORK_PERTEST)) {
            result = this.runTestsForkEach();
        }
        return result;
    }

    private ClassLoader createClassLoader() throws Exception {
        return SurefireBooter.createClassLoader(this.classpathUrls, this.childDelegation);
    }

    private static ClassLoader createClassLoader(List classpathUrls, boolean childDelegation) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator i = classpathUrls.iterator();
        while (i.hasNext()) {
            String url = (String)i.next();
            if (url == null) continue;
            File f = new File(url);
            urls.add(f.toURL());
        }
        if (childDelegation) {
            IsolatedClassLoader surefireClassLoader = new IsolatedClassLoader(ClassLoader.getSystemClassLoader(), true);
            Iterator iter = ((AbstractList)urls).iterator();
            while (iter.hasNext()) {
                URL url = (URL)iter.next();
                surefireClassLoader.addURL(url);
            }
            return surefireClassLoader;
        }
        URL[] u = new URL[urls.size()];
        urls.toArray(u);
        return new URLClassLoader(u, ClassLoader.getSystemClassLoader());
    }

    private static ClassLoader createForkingClassLoader(String basedir) throws Exception {
        Properties p = SurefireBooter.loadProperties(basedir, CLASSLOADER_PROPERTIES);
        String cp = p.getProperty("classpath");
        boolean childDelegation = "true".equals(p.getProperty("childDelegation", "false"));
        List<Object> urls = cp == null ? new ArrayList(0) : Arrays.asList(cp.split(PS));
        return SurefireBooter.createClassLoader(urls, childDelegation);
    }

    private boolean runTestsInProcess() throws Exception {
        ClassLoader surefireClassLoader = this.createClassLoader();
        Class<?> batteryExecutorClass = surefireClassLoader.loadClass(BATTERY_EXECUTOR);
        Object batteryExecutor = batteryExecutorClass.newInstance();
        Method run = batteryExecutorClass.getMethod("run", class$java$util$List == null ? (class$java$util$List = SurefireBooter.class$("java.util.List")) : class$java$util$List, class$java$util$List == null ? (class$java$util$List = SurefireBooter.class$("java.util.List")) : class$java$util$List, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$lang$String == null ? (class$java$lang$String = SurefireBooter.class$("java.lang.String")) : class$java$lang$String);
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(surefireClassLoader);
        Boolean result = (Boolean)run.invoke(batteryExecutor, this.reports, this.batteries, surefireClassLoader, this.reportsDirectory);
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        return result;
    }

    private boolean runTestsForkOnce() throws Exception {
        this.getForkOnceArgs();
        return this.fork(true);
    }

    private boolean runTestsForkEach() throws Exception {
        boolean noFailures = true;
        List testClasses = this.getTestClasses();
        for (int i = 0; i < testClasses.size(); ++i) {
            String testClass = (String)testClasses.get(i);
            this.getForkPerTestArgs(testClass);
            boolean result = this.fork(i == 0);
            if (result) continue;
            noFailures = false;
        }
        return noFailures;
    }

    private boolean fork(boolean showHeading) throws Exception {
        int returnCode;
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.basedir);
        cli.setExecutable(this.jvm);
        if (this.argLine != null) {
            cli.addArguments(StringUtils.split((String)this.argLine, (String)" "));
        }
        if (this.environmentVariables != null) {
            Iterator iter = this.environmentVariables.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)this.environmentVariables.get(key);
                cli.addEnvironment(key, value);
                if (!this.debug) continue;
                System.out.println("Environment: " + key + "=" + value + " added.");
            }
        }
        cli.createArgument().setValue("-classpath");
        cli.createArgument().setValue(this.surefireBooterJar + PS + this.plexusUtilsJar);
        cli.createArgument().setValue(RUNNER);
        cli.createArgument().setValue(this.basedir);
        if (this.workingDirectory != null) {
            cli.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
            cli.createArgument().setValue(this.workingDirectory.getAbsolutePath());
        }
        if (this.debug) {
            System.out.println(Commandline.toString((String[])cli.getCommandline()));
        }
        OutputStreamWriter consoleWriter = new OutputStreamWriter(System.out);
        ForkingWriterStreamConsumer out = new ForkingWriterStreamConsumer(consoleWriter, showHeading);
        ForkingWriterStreamConsumer err = new ForkingWriterStreamConsumer(consoleWriter, showHeading);
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (CommandLineException e) {
            throw new Exception("Error while executing forked tests.", e);
        }
        catch (Exception e) {
            throw new SurefireBooterForkException("Error while executing forked tests.", e);
        }
        return returnCode == 0;
    }

    private List getTestClasses() throws Exception {
        ClassLoader classLoader = this.createClassLoader();
        List instantiatedBatteries = Surefire.instantiateBatteries((List)this.batteries, (ClassLoader)classLoader);
        ArrayList testClasses = new ArrayList();
        Iterator i = instantiatedBatteries.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            Method m = o.getClass().getMethod("getSubBatteryClassNames", new Class[0]);
            List tests = (List)m.invoke(o, new Object[0]);
            testClasses.addAll(tests);
        }
        return testClasses;
    }

    private void getForkOnceArgs() throws Exception {
        this.getForkArgs(this.getStringArrayFromBatteries()[0]);
    }

    private void getForkPerTestArgs(String testClass) throws Exception {
        this.getForkArgs("org.apache.maven.surefire.battery.JUnitBattery|" + testClass);
    }

    private void getForkArgs(String batteryConfig) throws Exception {
        String reportClassNames = this.getListOfStringsAsString(this.reports, ",");
        Properties p = new Properties();
        String cp = "";
        for (int i = 0; i < this.classpathUrls.size(); ++i) {
            String url = (String)this.classpathUrls.get(i);
            if (url.indexOf("surefire-booter") > 0) {
                this.surefireBooterJar = url;
                continue;
            }
            if (url.indexOf("plexus-utils") > 0) {
                this.plexusUtilsJar = url;
                continue;
            }
            cp = cp.length() == 0 ? url : cp + PS + url;
        }
        p.setProperty("classpath", cp);
        p.setProperty("childDelegation", "" + this.childDelegation);
        FileOutputStream fos = new FileOutputStream(new File(this.basedir, CLASSLOADER_PROPERTIES));
        p.store(fos, "classpath entries");
        fos.close();
        if (this.systemProperties != null) {
            File f = new File(this.basedir, SYSTEM_PROPERTIES);
            fos = new FileOutputStream(f);
            this.systemProperties.store(fos, "system properties");
            fos.close();
        }
        p = new Properties();
        p.setProperty("reportClassNames", reportClassNames);
        p.setProperty("reportsDirectory", this.reportsDirectory);
        p.setProperty("batteryExecutorName", BATTERY_EXECUTOR);
        p.setProperty("forkMode", this.forkMode);
        p.setProperty("batteryConfig", batteryConfig);
        p.setProperty("debug", "" + this.debug);
        fos = new FileOutputStream(new File(this.basedir, SUREFIRE_PROPERTIES));
        p.store(fos, "surefire properties");
        fos.close();
    }

    public void reset() {
        this.batteries.clear();
        this.reports.clear();
        this.classpathUrls.clear();
    }

    private String getListOfStringsAsString(List listOfStrings, String delimiterParm) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator listOfStringsIterator = listOfStrings.iterator();
        String delimiter = "";
        while (listOfStringsIterator.hasNext()) {
            String string = (String)listOfStringsIterator.next();
            stringBuffer.append(delimiter);
            stringBuffer.append(string);
            delimiter = delimiterParm;
        }
        return new String(stringBuffer);
    }

    private String[] getStringArrayFromBatteries() {
        String[] batteryConfig = new String[this.batteries.size()];
        StringBuffer batteryBuffer = new StringBuffer();
        int batteryCounter = 0;
        Iterator j = this.batteries.iterator();
        while (j.hasNext()) {
            Object[] batteryArray = (Object[])j.next();
            batteryBuffer.append((String)batteryArray[0]);
            if (batteryArray[1] != null) {
                Object[] batteryParms = (Object[])batteryArray[1];
                for (int i = 0; i < 3; ++i) {
                    batteryBuffer.append("|");
                    batteryBuffer.append(batteryParms[i]);
                }
            }
            batteryConfig[batteryCounter++] = new String(batteryBuffer);
        }
        return batteryConfig;
    }

    private static Properties loadProperties(String basedir, String file) throws Exception {
        File f = new File(basedir, file);
        Properties p = new Properties();
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        f.deleteOnExit();
        p.load(new FileInputStream(f));
        return p;
    }

    private static Properties getSurefireProperties(String basedir) throws Exception {
        return SurefireBooter.loadProperties(basedir, SUREFIRE_PROPERTIES);
    }

    private static void setSystemProperties(String basedir) throws Exception {
        Properties p = SurefireBooter.loadProperties(basedir, SYSTEM_PROPERTIES);
        Iterator i = ((Hashtable)p).keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            System.setProperty(key, p.getProperty(key));
        }
    }

    public static void main(String[] args) throws Exception {
        Object[] batteryParms;
        Properties p;
        boolean debug;
        String basedir = args[0];
        String workingDirectory = null;
        if (args.length == 2) {
            workingDirectory = args[1];
        }
        ClassLoader classLoader = SurefireBooter.createForkingClassLoader(basedir);
        Thread.currentThread().setContextClassLoader(classLoader);
        SurefireBooter.setSystemProperties(basedir);
        if (workingDirectory != null) {
            System.setProperty("user.dir", workingDirectory);
        }
        if (debug = "true".equals((p = SurefireBooter.getSurefireProperties(basedir)).getProperty("debug", "false"))) {
            SurefireBooter.logClassLoader(classLoader);
        }
        String batteryExecutorName = p.getProperty("batteryExecutorName");
        Class<?> batteryExecutorClass = classLoader.loadClass(batteryExecutorName);
        Object batteryExecutor = batteryExecutorClass.newInstance();
        String reports = p.getProperty("reportClassNames");
        String[] reportClasses = reports.split(",");
        List<String> reportList = Arrays.asList(reportClasses);
        String batteryConfig = p.getProperty("batteryConfig");
        String[] batteryParts = batteryConfig.split("\\|");
        String batteryClassName = batteryParts[0];
        String forkMode = p.getProperty("forkMode");
        if (forkMode.equals(FORK_ONCE)) {
            batteryParms = new Object[batteryParts.length - 1];
            batteryParms[0] = new File(batteryParts[1]);
            String stringList = batteryParts[2];
            if (stringList.startsWith("[") && stringList.endsWith("]")) {
                stringList = stringList.substring(1, stringList.length() - 1);
            }
            ArrayList<String> includesList = new ArrayList<String>();
            String[] stringArray = stringList.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                includesList.add(stringArray[i].trim());
            }
            batteryParms[1] = includesList;
            stringList = batteryParts[3];
            ArrayList<String> excludesList = new ArrayList<String>();
            if (stringList.startsWith("[") && stringList.endsWith("]")) {
                stringList = stringList.substring(1, stringList.length() - 1);
            }
            stringArray = stringList.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                excludesList.add(stringArray[i].trim());
            }
            batteryParms[2] = excludesList;
        } else {
            batteryParms = new Object[]{batteryParts[1]};
        }
        ArrayList<Object[]> batteryHolders = new ArrayList<Object[]>();
        batteryHolders.add(new Object[]{batteryClassName, batteryParms});
        String reportsDirectory = p.getProperty("reportsDirectory");
        Method run = batteryExecutorClass.getMethod("run", class$java$util$List == null ? (class$java$util$List = SurefireBooter.class$("java.util.List")) : class$java$util$List, class$java$util$List == null ? (class$java$util$List = SurefireBooter.class$("java.util.List")) : class$java$util$List, class$java$lang$String == null ? (class$java$lang$String = SurefireBooter.class$("java.lang.String")) : class$java$lang$String);
        Object[] parms = new Object[]{reportList, batteryHolders, reportsDirectory};
        int returnCode = TESTS_FAILED;
        try {
            boolean result = (Boolean)run.invoke(batteryExecutor, parms);
            if (result) {
                returnCode = TESTS_SUCCEEDED;
            }
        }
        catch (IllegalArgumentException e) {
            returnCode = ILLEGAL_ARGUMENT_EXCEPTION;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnCode = OTHER_EXCEPTION;
        }
        System.exit(returnCode);
    }

    private static void logClassLoader(ClassLoader classLoader) {
        if (classLoader.getParent() != null) {
            SurefireBooter.logClassLoader(classLoader.getParent());
        }
        if (classLoader instanceof URLClassLoader) {
            System.out.println("ClassLoader: type" + classLoader.getClass() + ", value=" + classLoader);
            URLClassLoader ucl = (URLClassLoader)classLoader;
            URL[] u = ucl.getURLs();
            for (int i = 0; i < u.length; ++i) {
                System.out.println("           : " + u[i]);
            }
        } else {
            System.out.println("ClassLoader: type" + classLoader.getClass() + ", value=" + classLoader);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

