/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitplatform;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.surefire.junitplatform.RunListenerAdapter;
import org.apache.maven.surefire.junitplatform.TestMethodFilter;
import org.apache.maven.surefire.junitplatform.TestPlanScannerFilter;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public class JUnitPlatformProvider
extends AbstractProvider {
    static final String CONFIGURATION_PARAMETERS = "configurationParameters";
    private final ProviderParameters parameters;
    private final Launcher launcher;
    private final Filter<?>[] filters;
    private final Map<String, String> configurationParameters;

    public JUnitPlatformProvider(ProviderParameters parameters) {
        this(parameters, LauncherFactory.create());
    }

    JUnitPlatformProvider(ProviderParameters parameters, Launcher launcher) {
        this.parameters = parameters;
        this.launcher = launcher;
        this.filters = this.newFilters();
        this.configurationParameters = this.newConfigurationParameters();
        Logger.getLogger("org.junit").setLevel(Level.WARNING);
    }

    public Iterable<Class<?>> getSuites() {
        return this.scanClasspath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        RunResult runResult;
        block6: {
            ReporterFactory reporterFactory = this.parameters.getReporterFactory();
            try {
                RunListener runListener = reporterFactory.createReporter();
                ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)runListener));
                if (forkTestSet instanceof TestsToRun) {
                    this.invokeAllTests((TestsToRun)forkTestSet, runListener);
                    break block6;
                }
                if (forkTestSet instanceof Class) {
                    this.invokeAllTests(TestsToRun.fromClass((Class)((Class)forkTestSet)), runListener);
                    break block6;
                }
                if (forkTestSet == null) {
                    this.invokeAllTests(this.scanClasspath(), runListener);
                    break block6;
                }
                throw new IllegalArgumentException("Unexpected value of forkTestSet: " + forkTestSet);
            }
            finally {
                runResult = reporterFactory.close();
            }
        }
        return runResult;
    }

    private TestsToRun scanClasspath() {
        TestPlanScannerFilter filter = new TestPlanScannerFilter(this.launcher, this.filters);
        ScanResult scanResult = this.parameters.getScanResult();
        TestsToRun scannedClasses = scanResult.applyFilter((ScannerFilter)filter, this.parameters.getTestClassLoader());
        return this.parameters.getRunOrderCalculator().orderTestClasses(scannedClasses);
    }

    private void invokeAllTests(TestsToRun testsToRun, RunListener runListener) {
        LauncherDiscoveryRequest discoveryRequest = this.buildLauncherDiscoveryRequest(testsToRun);
        this.launcher.execute(discoveryRequest, new TestExecutionListener[]{new RunListenerAdapter(runListener)});
    }

    private LauncherDiscoveryRequest buildLauncherDiscoveryRequest(TestsToRun testsToRun) {
        LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request().filters(this.filters).configurationParameters(this.configurationParameters);
        for (Class testClass : testsToRun) {
            builder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((Class)testClass)});
        }
        return builder.build();
    }

    private Filter<?>[] newFilters() {
        ArrayList<TestMethodFilter> filters = new ArrayList<TestMethodFilter>();
        this.getPropertiesList("groups").map(TagFilter::includeTags).ifPresent(filters::add);
        this.getPropertiesList("excludegroups").map(TagFilter::excludeTags).ifPresent(filters::add);
        TestListResolver testListResolver = this.parameters.getTestRequest().getTestListResolver();
        if (!testListResolver.isEmpty()) {
            filters.add(new TestMethodFilter(testListResolver));
        }
        return filters.toArray(new Filter[filters.size()]);
    }

    Filter<?>[] getFilters() {
        return this.filters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> newConfigurationParameters() {
        String content = (String)this.parameters.getProviderProperties().get(CONFIGURATION_PARAMETERS);
        if (content == null) {
            return Collections.emptyMap();
        }
        try (StringReader reader = new StringReader(content);){
            HashMap<String, String> result = new HashMap<String, String>();
            Properties props = new Properties();
            props.load(reader);
            props.stringPropertyNames().forEach(key -> result.put((String)key, props.getProperty((String)key)));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error reading configurationParameters", e);
        }
    }

    Map<String, String> getConfigurationParameters() {
        return this.configurationParameters;
    }

    private Optional<List<String>> getPropertiesList(String key) {
        String property = (String)this.parameters.getProviderProperties().get(key);
        return StringUtils.isBlank((String)property) ? Optional.empty() : Optional.of(Arrays.stream(property.split("[,]+")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList()));
    }
}

