/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.TestSuiteXmlParser;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.xml.sax.SAXException;

public final class SurefireReportParser {
    private static final String INCLUDES = "*.xml";
    private static final String EXCLUDES = "*.txt, testng-failed.xml, testng-failures.xml, testng-results.xml, failsafe-summary*.xml";
    private final List<ReportTestSuite> testSuites = new ArrayList<ReportTestSuite>();
    private final ConsoleLogger consoleLogger;
    private final List<File> reportsDirectories;

    public SurefireReportParser(List<File> reportsDirectories, ConsoleLogger consoleLogger) {
        this.reportsDirectories = reportsDirectories;
        this.consoleLogger = consoleLogger;
    }

    public List<ReportTestSuite> parseXMLReportFiles() {
        ArrayList<File> xmlReportFiles = new ArrayList<File>();
        for (File reportsDirectory : this.reportsDirectories) {
            if (!reportsDirectory.exists()) continue;
            for (String xmlReportFile : SurefireReportParser.getIncludedFiles(reportsDirectory, INCLUDES, EXCLUDES)) {
                xmlReportFiles.add(new File(reportsDirectory, xmlReportFile));
            }
        }
        TestSuiteXmlParser parser = new TestSuiteXmlParser(this.consoleLogger);
        for (File aXmlReportFileList : xmlReportFiles) {
            try {
                this.testSuites.addAll(parser.parse(aXmlReportFileList.getAbsolutePath()));
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Error setting up parser for JUnit XML report", e);
            }
            catch (SAXException e) {
                throw new RuntimeException("Error parsing JUnit XML report " + aXmlReportFileList, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading JUnit XML report " + aXmlReportFileList, e);
            }
        }
        return this.testSuites;
    }

    public Map<String, Object> getSummary(List<ReportTestSuite> suites) {
        HashMap<String, Object> totalSummary = new HashMap<String, Object>();
        int totalNumberOfTests = 0;
        int totalNumberOfErrors = 0;
        int totalNumberOfFailures = 0;
        int totalNumberOfSkipped = 0;
        float totalElapsedTime = 0.0f;
        for (ReportTestSuite suite : suites) {
            totalNumberOfTests += suite.getNumberOfTests();
            totalNumberOfErrors += suite.getNumberOfErrors();
            totalNumberOfFailures += suite.getNumberOfFailures();
            totalNumberOfSkipped += suite.getNumberOfSkipped();
            totalElapsedTime += suite.getTimeElapsed();
        }
        float totalPercentage = this.computePercentage(totalNumberOfTests, totalNumberOfErrors, totalNumberOfFailures, totalNumberOfSkipped);
        totalSummary.put("totalTests", totalNumberOfTests);
        totalSummary.put("totalErrors", totalNumberOfErrors);
        totalSummary.put("totalFailures", totalNumberOfFailures);
        totalSummary.put("totalSkipped", totalNumberOfSkipped);
        totalSummary.put("totalElapsedTime", Float.valueOf(totalElapsedTime));
        totalSummary.put("totalPercentage", Float.valueOf(totalPercentage));
        return totalSummary;
    }

    public Map<String, List<ReportTestSuite>> getSuitesGroupByPackage(List<ReportTestSuite> testSuitesList) {
        HashMap<String, List<ReportTestSuite>> suitePackage = new HashMap<String, List<ReportTestSuite>>();
        for (ReportTestSuite suite : testSuitesList) {
            List<ReportTestSuite> suiteList = new ArrayList<ReportTestSuite>();
            if (suitePackage.get(suite.getPackageName()) != null) {
                suiteList = (List)suitePackage.get(suite.getPackageName());
            }
            suiteList.add(suite);
            suitePackage.put(suite.getPackageName(), suiteList);
        }
        return suitePackage;
    }

    public float computePercentage(int tests, int errors, int failures, int skipped) {
        float percentage = tests == 0 ? 0.0f : (float)(tests - errors - failures - skipped) / (float)tests;
        return percentage;
    }

    public List<ReportTestCase> getFailureDetails(List<ReportTestSuite> testSuites) {
        ArrayList<ReportTestCase> failureDetails = new ArrayList<ReportTestCase>();
        for (ReportTestSuite suite : testSuites) {
            for (ReportTestCase tCase : suite.getTestCases()) {
                if (tCase.isSuccessful()) continue;
                failureDetails.add(tCase);
            }
        }
        return failureDetails;
    }

    public static boolean hasReportFiles(File directory) {
        return directory != null && directory.isDirectory() && SurefireReportParser.getIncludedFiles(directory, INCLUDES, EXCLUDES).length != 0;
    }

    private static String[] getIncludedFiles(File directory, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(StringUtils.split((String)includes, (String)","));
        scanner.setExcludes(StringUtils.split((String)excludes, (String)","));
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

