/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.surefire.cli.CommandLineOption;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testng.utils.FailFastEventsSingleton;
import org.apache.maven.surefire.testng.utils.FailFastListener;
import org.apache.maven.surefire.testng.utils.Stoppable;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.internal.ConcurrencyUtils;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.testng.ITestListener;
import org.testng.TestNG;
import org.testng.annotations.Test;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestNGExecutor {
    private static final String DEFAULT_SUREFIRE_SUITE_NAME = "Surefire suite";
    private static final String DEFAULT_SUREFIRE_TEST_NAME = "Surefire test";
    private static final boolean HAS_TEST_ANNOTATION_ON_CLASSPATH = ReflectionUtils.tryLoadClass((ClassLoader)TestNGExecutor.class.getClassLoader(), (String)"org.testng.annotations.Test") != null;

    private TestNGExecutor() {
        throw new IllegalStateException("not instantiable constructor");
    }

    static void run(Iterable<Class<?>> testClasses, String testSourceDirectory, Map<String, String> options, RunListener reportManager, File reportsDirectory, TestListResolver methodFilter, List<CommandLineOption> mainCliOptions, int skipAfterFailureCount) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        Configurator configurator = TestNGExecutor.getConfigurator(options.get("testng.configurator"));
        if (TestNGExecutor.isCliDebugOrShowErrors(mainCliOptions)) {
            System.out.println("Configuring TestNG with: " + configurator.getClass().getSimpleName());
        }
        XmlMethodSelector groupMatchingSelector = TestNGExecutor.createGroupMatchingSelector(options);
        XmlMethodSelector methodNameFilteringSelector = TestNGExecutor.createMethodNameFilteringSelector(methodFilter);
        HashMap<String, SuiteAndNamedTests> suitesNames = new HashMap<String, SuiteAndNamedTests>();
        ArrayList<XmlSuite> xmlSuites = new ArrayList<XmlSuite>();
        for (Class<?> testClass : testClasses) {
            XmlTest xmlTest;
            TestMetadata metadata = TestNGExecutor.findTestMetadata(testClass);
            SuiteAndNamedTests suiteAndNamedTests = (SuiteAndNamedTests)suitesNames.get(metadata.suiteName);
            if (suiteAndNamedTests == null) {
                suiteAndNamedTests = new SuiteAndNamedTests();
                suiteAndNamedTests.xmlSuite.setName(metadata.suiteName);
                configurator.configure(suiteAndNamedTests.xmlSuite, options);
                xmlSuites.add(suiteAndNamedTests.xmlSuite);
                suitesNames.put(metadata.suiteName, suiteAndNamedTests);
            }
            if ((xmlTest = (XmlTest)suiteAndNamedTests.testNameToTest.get(metadata.testName)) == null) {
                xmlTest = new XmlTest(suiteAndNamedTests.xmlSuite);
                xmlTest.setName(metadata.testName);
                TestNGExecutor.addSelector(xmlTest, groupMatchingSelector);
                TestNGExecutor.addSelector(xmlTest, methodNameFilteringSelector);
                xmlTest.setXmlClasses(new ArrayList());
                suiteAndNamedTests.testNameToTest.put(metadata.testName, xmlTest);
            }
            xmlTest.getXmlClasses().add(new XmlClass(testClass.getName()));
        }
        testng.setXmlSuites(xmlSuites);
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, reportManager, reportsDirectory, skipAfterFailureCount, TestNGExecutor.extractVerboseLevel(options));
        testng.run();
    }

    private static boolean isCliDebugOrShowErrors(List<CommandLineOption> mainCliOptions) {
        return mainCliOptions.contains(CommandLineOption.LOGGING_LEVEL_DEBUG) || mainCliOptions.contains(CommandLineOption.SHOW_ERRORS);
    }

    private static TestMetadata findTestMetadata(Class<?> testClass) {
        Test testAnnotation;
        TestMetadata result = new TestMetadata();
        if (HAS_TEST_ANNOTATION_ON_CLASSPATH && null != (testAnnotation = TestNGExecutor.findAnnotation(testClass, Test.class))) {
            if (!StringUtils.isBlank((String)testAnnotation.suiteName())) {
                result.suiteName = testAnnotation.suiteName();
            }
            if (!StringUtils.isBlank((String)testAnnotation.testName())) {
                result.testName = testAnnotation.testName();
            }
        }
        return result;
    }

    private static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationType) {
        if (clazz == null) {
            return null;
        }
        T result = clazz.getAnnotation(annotationType);
        if (result != null) {
            return result;
        }
        return TestNGExecutor.findAnnotation(clazz.getSuperclass(), annotationType);
    }

    private static void addSelector(XmlTest xmlTest, XmlMethodSelector selector) {
        if (selector != null) {
            xmlTest.getMethodSelectors().add(selector);
        }
    }

    private static XmlMethodSelector createMethodNameFilteringSelector(TestListResolver methodFilter) throws TestSetFailedException {
        if (methodFilter != null && !methodFilter.isEmpty()) {
            String clazzName = "org.apache.maven.surefire.testng.utils.MethodSelector";
            try {
                Class<?> clazz = Class.forName(clazzName);
                Method method = clazz.getMethod("setTestListResolver", TestListResolver.class);
                method.invoke(null, methodFilter);
            }
            catch (Exception e) {
                throw new TestSetFailedException(e.getMessage(), (Throwable)e);
            }
            XmlMethodSelector xms = new XmlMethodSelector();
            xms.setName(clazzName);
            xms.setPriority(10000);
            return xms;
        }
        return null;
    }

    private static XmlMethodSelector createGroupMatchingSelector(Map<String, String> options) throws TestSetFailedException {
        String groups = options.get("groups");
        String excludedGroups = options.get("excludegroups");
        if (groups == null && excludedGroups == null) {
            return null;
        }
        String clazzName = "org.apache.maven.surefire.testng.utils.GroupMatcherMethodSelector";
        try {
            Class<?> clazz = Class.forName("org.apache.maven.surefire.testng.utils.GroupMatcherMethodSelector");
            Method method = clazz.getMethod("setGroups", String.class, String.class);
            method.invoke(null, groups, excludedGroups);
        }
        catch (Exception e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        XmlMethodSelector xms = new XmlMethodSelector();
        xms.setName("org.apache.maven.surefire.testng.utils.GroupMatcherMethodSelector");
        xms.setPriority(9999);
        return xms;
    }

    static void run(List<String> suiteFiles, String testSourceDirectory, Map<String, String> options, RunListener reportManager, File reportsDirectory, int skipAfterFailureCount) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        Configurator configurator = TestNGExecutor.getConfigurator(options.get("testng.configurator"));
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, reportManager, reportsDirectory, skipAfterFailureCount, TestNGExecutor.extractVerboseLevel(options));
        testng.setTestSuites(suiteFiles);
        testng.run();
    }

    private static Configurator getConfigurator(String className) {
        try {
            return (Configurator)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void postConfigure(TestNG testNG, String sourcePath, RunListener reportManager, File reportsDirectory, int skipAfterFailureCount, int verboseLevel) {
        testNG.setVerbose(verboseLevel);
        TestNGReporter reporter = TestNGExecutor.createTestNGReporter(reportManager);
        testNG.addListener((Object)reporter);
        if (skipAfterFailureCount > 0) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            testNG.addListener(ReflectionUtils.instantiate((ClassLoader)cl, (String)"org.apache.maven.surefire.testng.utils.FailFastNotifier", Object.class));
            testNG.addListener((ITestListener)new FailFastListener(TestNGExecutor.createStoppable(reportManager, skipAfterFailureCount)));
        }
        if (sourcePath != null) {
            testNG.setSourcePath(sourcePath);
        }
        testNG.setOutputDirectory(reportsDirectory.getAbsolutePath());
    }

    private static Stoppable createStoppable(final RunListener reportManager, int skipAfterFailureCount) {
        final AtomicInteger currentFaultCount = new AtomicInteger(skipAfterFailureCount);
        return new Stoppable(){

            public void fireStopEvent() {
                if (ConcurrencyUtils.countDownToZero((AtomicInteger)currentFaultCount)) {
                    FailFastEventsSingleton.getInstance().setSkipOnNextTest();
                }
                reportManager.testExecutionSkippedByUser();
            }
        };
    }

    private static TestNGReporter createTestNGReporter(RunListener reportManager) {
        try {
            Class.forName("org.testng.internal.IResultListener");
            Class<?> c = Class.forName("org.apache.maven.surefire.testng.ConfigurationAwareTestNGReporter");
            Constructor<?> ctor = c.getConstructor(RunListener.class);
            return (TestNGReporter)ctor.newInstance(reportManager);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Bug in ConfigurationAwareTestNGReporter", e.getCause());
        }
        catch (ClassNotFoundException e) {
            return new TestNGReporter(reportManager);
        }
        catch (Exception e) {
            throw new RuntimeException("Bug in ConfigurationAwareTestNGReporter", e);
        }
    }

    private static int extractVerboseLevel(Map<String, String> options) throws TestSetFailedException {
        try {
            String verbose = options.get("surefire.testng.verbose");
            return verbose == null ? 0 : Integer.parseInt(verbose);
        }
        catch (NumberFormatException e) {
            throw new TestSetFailedException("Provider property 'surefire.testng.verbose' should refer to number -1 (debug mode), 0, 1 .. 10 (most detailed).", (Throwable)e);
        }
    }

    private static class SuiteAndNamedTests {
        private XmlSuite xmlSuite = new XmlSuite();
        private Map<String, XmlTest> testNameToTest = new HashMap<String, XmlTest>();

        private SuiteAndNamedTests() {
        }
    }

    private static class TestMetadata {
        private String testName = "Surefire test";
        private String suiteName = "Surefire suite";

        private TestMetadata() {
        }
    }
}

