/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.resource;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.apache.myfaces.test.mock.resource.MockResource;
import org.apache.myfaces.test.mock.resource.MockResourceHandlerSupport;
import org.apache.myfaces.test.mock.resource.MockResourceLoader;
import org.apache.myfaces.test.mock.resource.MockResourceMeta;

public class MockResourceHandler
extends ResourceHandler {
    private boolean _resourceRequest;
    private MockResourceHandlerSupport resourceHandlerSupport;
    private ClassLoader _classLoader;

    public MockResourceHandler() {
        this._classLoader = MockResourceHandler.getContextClassLoader();
        this.resourceHandlerSupport = new MockResourceHandlerSupport(true, ".jsf", this._classLoader);
    }

    public MockResourceHandler(ClassLoader classLoader) {
        this._classLoader = classLoader == null ? MockResourceHandler.getContextClassLoader() : classLoader;
        this.resourceHandlerSupport = new MockResourceHandlerSupport(true, ".jsf", this._classLoader);
    }

    public MockResourceHandler(boolean extensionMapping, String mapping, ClassLoader classLoader) {
        this._classLoader = classLoader == null ? MockResourceHandler.getContextClassLoader() : classLoader;
        this.resourceHandlerSupport = new MockResourceHandlerSupport(extensionMapping, mapping, this._classLoader);
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        MockResource resource = null;
        if (contentType == null) {
            contentType = FacesContext.getCurrentInstance().getExternalContext().getMimeType(resourceName);
        }
        for (MockResourceLoader loader : this.getResourceHandlerSupport().getResourceLoaders()) {
            MockResourceMeta resourceMeta = this.deriveResourceMeta(loader, resourceName, libraryName);
            if (resourceMeta == null) continue;
            resource = new MockResource(resourceMeta, loader, this.getResourceHandlerSupport(), contentType);
            break;
        }
        return resource;
    }

    protected MockResourceMeta deriveResourceMeta(MockResourceLoader resourceLoader, String resourceName, String libraryName) {
        URL url;
        String localePrefix = this.getLocalePrefixForLocateResource();
        String resourceVersion = null;
        String libraryVersion = null;
        MockResourceMeta resourceId = null;
        if (localePrefix != null) {
            if (null != libraryName) {
                String pathToLib = localePrefix + '/' + libraryName;
                libraryVersion = resourceLoader.getLibraryVersion(pathToLib);
                if (null != libraryVersion) {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                } else {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(localePrefix, libraryName, libraryVersion, resourceName, resourceVersion);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(localePrefix + '/' + resourceName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(localePrefix, null, null, resourceName, resourceVersion);
                }
            }
            if (resourceId != null && (url = resourceLoader.getResourceURL(resourceId)) == null) {
                resourceId = null;
            }
        }
        if (resourceId == null) {
            if (null != libraryName) {
                String pathToResource;
                libraryVersion = resourceLoader.getLibraryVersion(libraryName);
                if (null != libraryVersion) {
                    pathToResource = libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                } else {
                    pathToResource = libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(null, libraryName, libraryVersion, resourceName, resourceVersion);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(resourceName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = resourceLoader.createResourceMeta(null, null, null, resourceName, resourceVersion);
                }
            }
            if (resourceId != null && (url = resourceLoader.getResourceURL(resourceId)) == null) {
                resourceId = null;
            }
        }
        return resourceId;
    }

    public String getRendererTypeForResourceName(String resourceName) {
        if (resourceName.endsWith(".js")) {
            return "javax.faces.resource.Script";
        }
        if (resourceName.endsWith(".css")) {
            return "javax.faces.resource.Stylesheet";
        }
        return null;
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        return this._resourceRequest;
    }

    public boolean libraryExists(String libraryName) {
        String localePrefix = this.getLocalePrefixForLocateResource();
        String pathToLib = localePrefix != null ? localePrefix + '/' + libraryName : libraryName;
        try {
            URL url = FacesContext.getCurrentInstance().getExternalContext().getResource("/" + pathToLib);
            return url != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    protected String getLocalePrefixForLocateResource() {
        Locale locale;
        ResourceBundle bundle;
        String localePrefix = null;
        FacesContext context = FacesContext.getCurrentInstance();
        String bundleName = context.getApplication().getMessageBundle();
        if (null != bundleName && (bundle = ResourceBundle.getBundle(bundleName, locale = context.getApplication().getViewHandler().calculateLocale(context), MockResourceHandler.getContextClassLoader())) != null) {
            try {
                localePrefix = bundle.getString("javax.faces.resource.localePrefix");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return localePrefix;
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() != null) {
            try {
                ClassLoader cl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws PrivilegedActionException {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                return cl;
            }
            catch (PrivilegedActionException pae) {
                throw new FacesException((Throwable)pae);
            }
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public MockResourceHandlerSupport getResourceHandlerSupport() {
        return this.resourceHandlerSupport;
    }

    public void setResourceHandlerSupport(MockResourceHandlerSupport resourceHandlerSupport) {
        this.resourceHandlerSupport = resourceHandlerSupport;
    }

    public void setResourceRequest(boolean resourceRequest) {
        this._resourceRequest = resourceRequest;
    }

    public boolean isResourceRequest() {
        return this._resourceRequest;
    }
}

