/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.webapp.api.runner;

import org.apache.myfaces.test.webapp.api.ResourceFinder;
import org.apache.myfaces.test.webapp.api.WebappTestConfigurator;
import org.apache.myfaces.test.webapp.api.tester.WebappTester;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappTestRunner
extends Arquillian {
    private WebappTester webappTester;
    private WebappTestConfigurator wtConfig = WebappTestConfigurator.getCurrentInstance();

    public WebappTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.wtConfig.configure(klass);
        this.webappTester = (WebappTester)ResourceFinder.getResource(ResourceFinder.WEBAPP_TESTER);
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        if (this.wtConfig.isTestSuiteConfig() && !this.wtConfig.isInContainer()) {
            this.run(notifier);
        }
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement originalStatement) {
        if (this.wtConfig.isInContainer()) {
            this.webappTester.setUpTestMethod();
        }
        return super.withBefores(method, target, originalStatement);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement originalStatement) {
        final Statement statementWithAfters = super.withAfters(method, target, originalStatement);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                statementWithAfters.evaluate();
                if (WebappTestRunner.this.wtConfig.isInContainer()) {
                    try {
                        WebappTestRunner.this.webappTester.executeTestMethod();
                    }
                    finally {
                        WebappTestRunner.this.webappTester.tearDownTestMethod();
                    }
                }
            }
        };
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (this.getTestClass().getJavaClass().isInstance(test)) {
            this.wtConfig.injectAssertableProxies(test);
        }
        return super.methodInvoker(method, test);
    }
}

