/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UIMenu;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(MenuRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        boolean firstLevel;
        super.prepareRender(facesContext, component);
        UIMenu menu = (UIMenu)component;
        boolean bl = firstLevel = !"Menu".equals(menu.getParent().getRendererType());
        if (firstLevel) {
            ComponentUtils.addCurrentMarkup((SupportsMarkup)menu, (Markup)Markup.TOP);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIMenu menu = (UIMenu)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)menu);
        boolean disabled = menu.isDisabled();
        boolean firstLevel = !"Menu".equals(menu.getParent().getRendererType());
        boolean isParentMenu = menu.getChildCount() > 0;
        writer.startElement("li", (UIComponent)menu);
        writer.writeClassAttribute(Classes.create((UIComponent)menu));
        StringBuilder backgroundImage = null;
        StringBuilder backgroundPosition = null;
        if (menu.getImage() != null) {
            backgroundImage = new StringBuilder();
            backgroundPosition = new StringBuilder();
            backgroundImage.append("url('");
            backgroundImage.append(ResourceManagerUtils.getImageOrDisabledImageWithPath((FacesContext)facesContext, (String)menu.getImage(), (boolean)menu.isDisabled()));
            backgroundImage.append("')");
            backgroundPosition.append("left center");
        }
        if (isParentMenu && !firstLevel) {
            if (backgroundImage == null) {
                backgroundImage = new StringBuilder();
                backgroundPosition = new StringBuilder();
            } else {
                backgroundImage.append(",");
                backgroundPosition.append(",");
            }
            backgroundImage.append("url('");
            backgroundImage.append(ResourceManagerUtils.getImageOrDisabledImage((FacesContext)facesContext, (String)"image/MenuArrow", (boolean)menu.isDisabled()));
            backgroundImage.append("')");
            backgroundPosition.append("right center");
        }
        if (backgroundImage != null) {
            Style style = new Style();
            style.setBackgroundImage(backgroundImage.toString());
            style.setBackgroundPosition(backgroundPosition.toString());
            writer.writeStyleAttribute(style);
        }
        writer.startElement("a", (UIComponent)menu);
        writer.writeAttribute("href", "#", false);
        if (!component.isTransient()) {
            writer.writeIdAttribute(component.getClientId(facesContext));
        }
        if (!disabled && label.getAccessKey() != null) {
            writer.writeAttribute("accesskey", Character.toString(label.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey(), component.isTransient() ? null : component.getClientId(facesContext));
        }
        HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
        writer.endElement("a");
        if (isParentMenu) {
            writer.startElement("ol", (UIComponent)menu);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        boolean isParentMenu;
        UIMenu menu = (UIMenu)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        boolean bl = isParentMenu = menu.getChildCount() > 0;
        if (isParentMenu) {
            writer.endElement("ol");
        }
        writer.endElement("li");
    }
}

